package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbDeliveryLoadingCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.AsnHeaderResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 在途宝--货物出货任务
 *
 * @author zhangjj
 * @date 2022/9/23 17:03
 */
@Component
public class UiBotModelBuildZTBShippingTaskStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ZhilinkService zhilinkService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        Boolean isSubmit = false;
        String planArrivalDate = "";
        if (apiRawData.get("isSubmit") != null && (Boolean) apiRawData.get("isSubmit")) {
            isSubmit = true;
            planArrivalDate = apiRawData.getString("plan_arrival_date");
        }
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId;
        String tmActivityId;
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        String taskNo = "";
        Map<String, Object> deliveryHead = (Map<String, Object>) pcUiBotModel.getPageData().get("delivery_head");
        if (!CollectionUtils.isEmpty(deliveryHead)) {
            taskNo = (String) deliveryHead.get("task_no");
        }

        AsnHeaderResponse asnHeaderResponse = zhilinkService.getAsnHeaderByTaskNo(taskNo, apiRequest.getTenantId(), locale, apiRequest.getIamUserToken());
        if (StringUtils.hasLength(asnHeaderResponse.getPlanArrivalDate())) {
            planArrivalDate = asnHeaderResponse.getPlanArrivalDate();
        }
        Boolean noUnloading = false;
        /**
         * 1.获取装车数量
         * 2.获取待装车货物
         * 3.获取已装车货物
         */
        ZtbDeliveryLoadingCount counts = digiwinEspProxyService.getDeliveryLoadingCount(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        List<ZtbCargoUnloading> ztbCargoUnloadings = digiwinEspProxyService.getDeliveryUnloadingList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        List<ZTBDriverVehicle> ztbDriverVehicles = digiwinEspProxyService.getDeliveryLoadedCarList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, taskNo);
        if (!CollectionUtils.isEmpty(ztbDriverVehicles)) {
            isSubmit = true;
        }
        if (CollectionUtils.isEmpty(ztbCargoUnloadings)) {
            noUnloading = true;
        }
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            String layoutType = layout.getType();
            String schema = layout.getSchema();
            switch (layoutType) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    pageData.put(schema, titleBody);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea area = JsonUtil.objectToJavaObject(pageData.get(schema), BlankArea.class);
                    pageData.put(schema, area);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_LOGISTICS".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, asnHeaderResponse,
                                JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class), !isSubmit);
                    } else if ("plan_arrival_date".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildAppointmentDeliveryDate(locale, layout,
                                localeService.getLanguageValue(locale, layout.getLabel()), isSubmit, planArrivalDate);
                    }
                    pageData.put(schema, customGroup);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    customTabs.detailMessage(customTabs, counts, ztbCargoUnloadings, ztbDriverVehicles, localeService, locale, isSubmit, digiwinDmcProxyService);
                    pageData.put(schema, customTabs);
                    break;
                case MultiFunctionList.COMPONENT_TYPE:
                    //货物信息
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.NO_CHOICE.toString());
                    multiFunctionList.setPageable(true);
                    multiFunctionList.setTitle(localeService.getLanguageValue(locale, multiFunctionList.getTitle()));
                    multiFunctionList.setSearch(false);
                    multiFunctionList.setDataUrl("/mobile/v1/ztb/cargo/information");
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.CARD.toString());
                    ApiRawData rawData = new ApiRawData();
                    rawData.put("task_no", taskNo);
                    rawData.put("isLoadCar", false);
                    multiFunctionList.setRawData(rawData);
                    pageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    if (!noUnloading) {
                        //底部按钮-提交出库
                        List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                        BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
                        bottomButton.setName(localeService.getLanguageValue(locale, "[-] 扫描车辆"));
                        bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                        Action action = new Action();
                        action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN_COTAIN_OCR.getValue());
                        Map<String, Object> buttonRawData = new HashMap<>(4);
                        buttonRawData.put("task_no", taskNo);
                        buttonRawData.put("cargo_infomation", ztbCargoUnloadings == null ? Collections.emptyList() : ztbCargoUnloadings);
                        buttonRawData.put("ztbCargoUnloadingSize", CollectionUtils.isEmpty(ztbCargoUnloadings) ? 0 : ztbCargoUnloadings.size());
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("scanRequestId", ComponentSettingRequestIdEnum.OCR_ZTB_CAR_NUMBER);
                        buttonRawData.put("taskId", dataId);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                        //rawData里存提交接口所需参数
                        UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
                        if (uiBotAction != null) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }

                        action.setRawData(buttonRawData);
                        bottomButton.setAction(action);
                        bottomButtonList.add(bottomButton);
                        pageData.put(schema, bottomButtonList);
                    }
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

}
