package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 在途宝--货物出货任务--底部弹窗车辆页面
 *
 * @author zhangjj
 * @date 2022/9/28 16:28
 */
@Component
public class UiBotModelBuildZTBShippingTaskVehicleInfoStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        List<Map<String, Object>> vehicleInfos = (List<Map<String, Object>>) rawData.get("vehicle_infos");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        List<UiBotLayout> newLayoutList = new ArrayList<>();
        UiBotPageData newUibotPageData = new UiBotPageData();
        Boolean hasButton = false;
        UiBotLayout buttonLayout = new UiBotLayout();
        for (Map<String, Object> vehicleInfo : vehicleInfos) {
            UiBotLayout customLayout = new UiBotLayout();

            String customSchema = UUIDUtil.getUuid();
            customLayout.setSchema(customSchema);
            customLayout.setType(Card.COMPONENT_TYPE);
            Card card = new Card();
            List<CardContent> cardContents = card.getContent();

            for (UiBotLayout layout : layoutList) {
                String type = layout.getType();
                String schema = layout.getSchema();
                CardContent content = new CardContent();
                switch (type) {
                    case Field.COMPONENT_TYPE:
                        Field field = JsonUtil.objectToJavaObject(pageData.get(schema), Field.class);
                        if ("license_plate_no".equalsIgnoreCase(schema)) {
                            card.setTitle((String) vehicleInfo.get(schema));
                        } else {
                            content.setValue((String) vehicleInfo.get(schema));
                            content.setLabel(localeService.getLanguageValue(locale, field.getLabel()));
                            cardContents.add(content);
                        }
                        break;
                    case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                        if (!hasButton) {
                            buttonLayout = layout;
                            BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                                    pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                                    BottomButtonList.class
                            );
                            bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                                String nameKey = bottomButtonDigiwinAthena.getName();
                                bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                                if (ActionTypeEnum.CALL_API_BACK_TWO.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                                    Action action = bottomButtonDigiwinAthena.getAction();
                                    ConfirmPop confirmPop = action.getConfirmPop();
                                    confirmPop.setContent(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), confirmPop.getContent()));
                                    ApiRawData buttonRawData = new ApiRawData();
                                    buttonRawData.put("task_no", rawData.get("task_no"));
                                    buttonRawData.put("biz_id", "ZTB");
                                    buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO.toString());
                                    buttonRawData.put("action", rawData.get("action"));
                                    buttonRawData.put("data", rawData.get("data"));
                                    action.setRawData(buttonRawData);
                                    bottomButtonDigiwinAthena.setAction(action);
                                }
                            });
                            newUibotPageData.put(schema, bottomButtonList);
                            hasButton = true;
                        }
                        break;
                    default:
                        break;
                }
            }
            newLayoutList.add(customLayout);
            newUibotPageData.put(customSchema, card);
        }
        newLayoutList.add(buttonLayout);
        uiBotModel.setLayout(newLayoutList);
        uiBotModel.setPageData(newUibotPageData);
        return uiBotModel;
    }
}
