package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author wuyang
 * @desc 在途宝收货确认
 */
@Component("uiBotModelBuildZTBTransportFactoryGuideStrategy")
public class UiBotModelBuildZTBTransportFactoryGuideStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    String transportNo = ObjectUtil.isEmpty(rawData.get("transportNo")) ? "" : StrUtil.toString(rawData.get("transportNo"));
                    Map<String, Object> transportEntryArrangement = digiwinEspProxyService.getTransportEntryArrangement(
                            iamUserToken, tenantId, locale, transportNo);
                    card.create(card, localeService, locale, transportNo, transportEntryArrangement);
                    pageData.put(schema, card);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
