package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * @author wuyang
 * @desc 在途宝收货确认
 */
@Component("uiBotModelBuildZTBTransportFactoryVoucherStrategy")
public class UiBotModelBuildZTBTransportFactoryVoucherStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBTransportFactoryVoucherStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        String transportNo = rawData.getString("transportNo");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();

        Map<String, Object> transportVehicleInfo = digiwinEspProxyService.getTransportVehicleInfo(
                iamUserToken, tenantId, locale, transportNo);

        Map<String, Object> transportEntryArrangement = digiwinEspProxyService.getTransportEntryArrangement(
                iamUserToken, tenantId, locale, transportNo);

        for (UiBotLayout layout : layoutList) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "Entry_Certificate":
                    Map<String, Object> resultMap = new HashMap<>();

                    //delivery
                    Map<String, Object> deliveryMap = new HashMap<>();
                    deliveryMap.put("title", "发");
                    Card card = new Card();
                    card.setCmptUuid(UUIDUtil.getUuid());
                    card.setStyle(1);
                    List<CardContent> contents = new ArrayList<>();
                    CardContent cardContent = new CardContent();
                    cardContent.setLabel(localeService.getLanguageValue(locale, "发货公司"));
                    cardContent.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("supplier_company_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("supplier_company_name")));
                    cardContent.setValueStyleType(1);
                    cardContent.setSchema("supplier_company_name");
                    contents.add(cardContent);
                    card.setContent(contents);
                    deliveryMap.put("dataItem", card);
                    resultMap.put("delivery", deliveryMap);

                    //graphic
                    resultMap.put("graphic", GraphicDisplay.createNoSubTitle(JsonUtil.objectToJavaObject(
                            transportVehicleInfo, ZTBDriverVehicle.class), 2, digiwinDmcProxyService));

                    //receive
                    Map<String, Object> receiveMap = new HashMap<>();
                    receiveMap.put("title", "收");
                    Card card1 = new Card();
                    card1.setCmptUuid(UUIDUtil.getUuid());
                    card1.setStyle(1);
                    List<CardContent> contents1 = new ArrayList<>();

                    CardContent cardContent1 = new CardContent();
                    cardContent1.setLabel(localeService.getLanguageValue(locale, "收货公司"));
                    cardContent1.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("receiver_company_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("receiver_company_name")));
                    cardContent1.setValueStyleType(1);
                    cardContent1.setSchema("receiver_company_name");
                    contents1.add(cardContent1);

                    CardContent cardContent2 = new CardContent();
                    cardContent2.setLabel(localeService.getLanguageValue(locale, "收货员"));
                    cardContent2.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("unloader_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("unloader_name")));
                    cardContent2.setValueStyleType(1);
                    cardContent2.setSchema("unloader_name");
                    contents1.add(cardContent2);

                    CardContent cardContent3 = new CardContent();
                    cardContent3.setLabel(localeService.getLanguageValue(locale, "联系方式"));
                    cardContent3.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("unloader_phone")) ? "-" : StrUtil.toString(transportEntryArrangement.get("unloader_phone")));
                    cardContent3.setValueStyleType(1);
                    cardContent3.setType("PHONE");
                    cardContent3.setSchema("unloader_phone");
                    contents1.add(cardContent3);

                    CardContent cardContent4 = new CardContent();
                    cardContent4.setLabel(localeService.getLanguageValue(locale, "仓库号"));
                    cardContent4.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("warehouse_no")) ? "-" : StrUtil.toString(transportEntryArrangement.get("warehouse_no")));
                    cardContent4.setValueStyleType(1);
                    cardContent4.setSchema("warehouse_no");
                    contents1.add(cardContent4);

                    CardContent cardContent5 = new CardContent();
                    cardContent5.setLabel(localeService.getLanguageValue(locale, "卸货月台"));
                    cardContent5.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("platform_no")) ? "-" : StrUtil.toString(transportEntryArrangement.get("platform_no")));
                    cardContent5.setValueStyleType(1);
                    cardContent5.setSchema("platform_no");
                    contents1.add(cardContent5);

                    CardContent cardContent6 = new CardContent();
                    cardContent6.setLabel(localeService.getLanguageValue(locale, "入厂时间"));
                    cardContent6.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("arrival_time")) ? "-" : StrUtil.toString(transportEntryArrangement.get("arrival_time")));
                    cardContent6.setValueStyleType(1);
                    cardContent6.setSchema("arrival_time");
                    contents1.add(cardContent6);

                    card1.setContent(contents1);
                    receiveMap.put("dataItem", card1);
                    resultMap.put("receive", receiveMap);
                    resultMap.put("title", localeService.getLanguageValue(locale, "入厂凭证"));
                    pageData.put(schema, resultMap);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
