package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.TimeSlot;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @author wuyang
 * @desc 在途宝收货确认
 */
@Component("uiBotModelBuildZTBTransportForwardingAgentStrategy")
public class UiBotModelBuildZTBTransportForwardingAgentStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildZTBTransportForwardingAgentStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.
                getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        if (StringUtils.hasLength(digiwinAtmcBacklogDetail.getProxyToken())) {
            apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        String transportNo = "";
        String taskNo = "";
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        }
//        Map<String, Object> transportMainInfo = digiwinEspProxyService.
//                getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        DigiwinTransportResponse transportMainInfo = digiwinEspProxyService.getTransportMainInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);

        Map<String, Object> transportVehicleInfo = digiwinEspProxyService.getTransportVehicleInfo(
                iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case GraphicDisplay.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), GraphicDisplay.createNoSubTitle(JsonUtil.objectToJavaObject(
                            transportVehicleInfo, ZTBDriverVehicle.class), 1, digiwinDmcProxyService));
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_ONE".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class), false);
                    } else if ("CUSTOM_GROUP_FOUR".equalsIgnoreCase(schema)) {
                        customGroup = buildPlatFormMessageGroup(locale, transportMainInfo,
                                JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), UiBotModel.class), (String) ((Map<String, Object>) uiBotModel.getPageData().get(schema)).get("name"));
                    }
                    pageData.put(schema, customGroup);
                    break;
                case PageButton.COMPONENT_TYPE:
                    PageButton pageButton = JsonUtil.objectToJavaObject(pageData.get(schema), PageButton.class);
                    pageButton.setName(localeService.getLanguageValue(locale, pageButton.getName()));
                    Action pageButtonAction = pageButton.getAction();
                    pageButtonAction.setDataId(transportNo);
                    pageButton.setAction(pageButtonAction);
                    pageData.put(schema, pageButton);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    BottomButtonList newBottomButtonList = new BottomButtonList();
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        if (action != null) {
                            if (action.getConfirmPop() != null && StringUtils.hasLength(action.getConfirmPop().getContent())) {
                                action.getConfirmPop().setContent(localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                            } else if (StringUtils.hasLength(action.getJumpPageTitle())) {
                                action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                        }
                        Map<String, Object> buttonRawData = new HashMap<>();
                        if (action.getRawData() != null) {
                            buttonRawData = (Map<String, Object>) action.getRawData();
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        //rawData里存提交接口所需参数
                        UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);
                        newBottomButtonList.add(bottomButtonDigiwinAthena);
                    });
                    pageData.put(schema, newBottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 在途宝展示月台信息
     *
     * @param locale
     * @param transportMainInfo
     * @param uiBotModel
     * @param name
     * @return
     */
    private CustomGroup buildPlatFormMessageGroup(String locale, DigiwinTransportResponse transportMainInfo, UiBotModel uiBotModel, String name) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(localeService.getLanguageValue(locale, name));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map<String, Object> dataMap = JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(transportMainInfo), Map.class);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if ("appoint_time".equalsIgnoreCase(schema)) {
                        String date = StringUtils.hasLength(transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                        String[] values = date.split(" ");
                        String value = "";
                        if (values.length > 1) {
                            value = values[0];
                        } else {
                            value = date;
                        }
                        pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(
                                layout.getmLabelText().get(locale), value));
                    } else if ("time_slot".equalsIgnoreCase(schema)) {
                        List<TimeSlot> timeSlots = transportMainInfo.getTimeSlot();
                        if (timeSlots != null && timeSlots.size() > 0) {
                            String value = transportMainInfo.getTimeSlots(timeSlots);
                            pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(layout.getmLabelText().get(locale),
                                    value));
                        }
                    } else {
                        pageData.put(schema, Field.createLabelValueLeftFieldNoNewLine(
                                layout.getmLabelText().get(locale), (String) dataMap.get(schema)));
                    }
                    break;
                default:
                    break;
            }
        }
        CustomGroupContent content = new CustomGroupContent();
        content.setPageData(pageData);
        content.setLayout(uiBotLayouts);
        customGroup.setContent(content);
        customGroup.setHiddenConfig(new HiddenConfig());
        customGroup.setUseExpand(false);
        customGroup.setHasDetail(false);
        return customGroup;
    }

    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
