package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 在途宝-运输在途-送货排程界面
 *
 * @author zhangjj
 * @date 2022/12/9 16:33
 */
@Component
class UiBotModelBuildZTBTransportScheduleStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        String transportNo = apiRequest.getDataId();
        List<UiBotLayout> newLayoutList = new ArrayList<>();
        //获取送回排程信息
        List<Map<String, Object>> scheduleList = digiwinEspProxyService.getShippingSchedule(apiRequest.getIamUserToken(), apiRequest.getTenantId(), locale, transportNo);
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "${CARD}":
                    if (!CollectionUtils.isEmpty(scheduleList)) {
                        scheduleList.forEach(schedule -> {
                            Card card = new Card();
                            card.setTitle((String) schedule.get("arrival_desc"));
                            List<CardContent> content = new ArrayList<>();
                            CardContent deliveryCardContent = new CardContent();
                            deliveryCardContent.setLabel(localeService.getLanguageValue(locale, "起点"));
                            deliveryCardContent.setValue((String) schedule.get("delivery_address"));
                            deliveryCardContent.setValueStyleType(1);
                            content.add(deliveryCardContent);
                            CardContent receiptCardContent = new CardContent();
                            receiptCardContent.setLabel(localeService.getLanguageValue(locale, "终点"));
                            receiptCardContent.setValue((String) schedule.get("receipt_address"));
                            receiptCardContent.setValueStyleType(1);
                            content.add(receiptCardContent);
                            CardContent receiverNameCardContent = new CardContent();
                            receiverNameCardContent.setLabel(localeService.getLanguageValue(locale, "联系人"));
                            receiverNameCardContent.setValue((String) schedule.get("receiver_name"));
                            receiverNameCardContent.setValueStyleType(1);
                            content.add(receiverNameCardContent);
                            CardContent receiverMobileCardContent = new CardContent();
                            receiverMobileCardContent.setLabel(localeService.getLanguageValue(locale, "联系电话"));
                            receiverMobileCardContent.setValue((String) schedule.get("receiver_mobile"));
                            receiverMobileCardContent.setValueStyleType(1);
                            receiverMobileCardContent.setType("PHONE");
                            content.add(receiverMobileCardContent);
                            card.setContent(content);
                            String cardSchema = UUIDUtil.getUuid();
                            UiBotLayout cardLayout = new UiBotLayout();
                            cardLayout.setSchema(cardSchema);
                            cardLayout.setType(Card.COMPONENT_TYPE);
                            newLayoutList.add(cardLayout);
                            pageData.put(cardSchema, card);
                        });
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, bottomButtonDigiwinAthena.getName()));
                    });
                    newLayoutList.add(layout);
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setLayout(newLayoutList);
        return uiBotModel;
    }
}
