package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputSingleSelectOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 运输在途-异常报警页面
 *
 * @author 吴阳
 * @date 20230227
 */
@Component
public class UiBotModelBuildZTBTransportShiftingAbnormalAlarmStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
//                case InputMultiText.COMPONENT_TYPE:
////                    pageData.put(schema, InputMultiText.create(localeService.getLanguageValue(
////                            locale, layout.getLabel()), localeService.getLanguageValue(locale, "侦测发现您长时间未变动位置，停留时间较长，运单可能会有晚点风险，请尽快回报停留原因"), true, true, locale,
////                            ""));
//                    pageData.put(schema, TitleBody.create(locale, digiwinAtmcBacklogDetail, data));
//                    break;
                case InputSingleText.COMPONENT_TYPE:
                    InputSingleText singleText = InputSingleText.create(schema, layout.getmLabelText().get(locale),
                            false, true, locale, "", false);
                    if (StrUtil.equals(schema, "licensePlateNo")){
                        singleText.setInputType(InputTypeEnum.INPUT_LICENSE_PLAT.getValue());
                    }
                    pageData.put(schema, singleText);
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    InputNumeric inputNumeric = InputNumeric.create(11, 0, "", layout.getmLabelText().get(locale),
                            InputNumericTypeEnum.INTEGER.getValue());
                    inputNumeric.setRequired(false);
                    pageData.put(schema, inputNumeric);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    pageData.put(schema, InputMultiText.create(schema,
                            layout.getmLabelText().get(locale),
                            "", true,
                            false, false, locale));
                    break;
                case ButtonSingleSelect.COMPONENT_TYPE:
                    pageData.put(schema, ButtonSingleSelect.createByZtbShiftingAbnormalAlarm(layout, locale, false));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                        if (ActionTypeEnum.CALL_API.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            Map<String, Object> buttonRawData = ObjectUtil.isEmpty(action.getRawData()) ? new HashMap<>() : (Map<String, Object>) action.getRawData();
                            Object buttonActionId = buttonRawData.get("action_id");
                            if (StrUtil.equals(StrUtil.toString(buttonRawData.get("action_id")), "cancel")) {
                                bottomButtonDigiwinAthena.setIsCheckButton(false);
                            }
                            buttonRawData.put("transport_no", rawData.get("transport_no"));
                            buttonRawData.put("task_no", rawData.get("task_no"));
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", pageSetting.getPageId());
                            buttonRawData.put("action", rawData.get("action"));
                            buttonRawData.put("data", rawData.get("data"));
                            buttonRawData.put("notValidInput", true);
                            buttonRawData.put("action_id", "shifting");
                            buttonRawData.put("button_action_id", buttonActionId);
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
