package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.HiddenConfig;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.PageButton;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.mapaddress.MapAddress;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.TimeSlot;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 在途宝-运输在途页面
 *
 * @author zhangjj
 * @date 2022/12/5 15:16
 */
@Slf4j
@Component
public class UiBotModelBuildZTBTransportStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String iamUserToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        String dataId = apiRequest.getDataId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        //todo
        //调用web端三个接口
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(locale, iamUserToken, dataId);
        String tmTaskId = "";
        String tmActivityId = "";
        if (null != apiRequest.getExtraParameter()) {
            tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
            tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        } else {
            tmTaskId = digiwinAtmcBacklogDetail.getTmTaskId();
            tmActivityId = digiwinAtmcBacklogDetail.getTmActivityId();
        }
        ApiRawData apiRawData = apiRequest.getRawData() != null ? apiRequest.getRawData() : new ApiRawData();
        apiRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
        digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(locale, iamUserToken, tenantId, dataId);
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(locale, iamUserToken, tenantId, dataId, tmTaskId, tmActivityId, apiRawData);
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
        }
        String transportNo;
        String taskNo;
        List<Map<String, Object>> deliveryDetailList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("cargo_information");
        if (!CollectionUtils.isEmpty(deliveryDetailList)) {
            taskNo = String.valueOf(deliveryDetailList.get(0).get("task_no"));
            transportNo = String.valueOf(deliveryDetailList.get(0).get("transport_no"));
        } else {
            taskNo = "";
            transportNo = "";
        }
        DigiwinTransportResponse transportMainInfo = digiwinEspProxyService.getTransportMainInfo(iamUserToken, apiRequest.getTenantId(), locale, transportNo);

        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    titleBody.setLabelPosition(TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition());
                    pageData.put(schema, titleBody);
//                    List<Tag> tags = titleBody.getTags();
                    //二维码
//                    Tag qrCodeTag = Tag.createBlueBgdWriteTextStateTag(LocaleUtil.getMobileTextByKey(locale, "运单二维码") + ">");
//                    qrCodeTag.setLabelPosition(TitleLabelPositionEnum.RIGHT_TO_TITLE.getPosition());
//                    Action qrCodeAction = new Action<>();
//                    qrCodeAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
//                    qrCodeAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_QR_CODE.toString());
//                    qrCodeAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "运单二维码"));
//                    qrCodeAction.setDataId(transportNo);
//                    Map<String, Object> qrCodeActionRawData = new HashMap<>();
//                    qrCodeActionRawData.put("transport_no", transportNo);
//                    qrCodeActionRawData.put("task_no", taskNo);
//                    qrCodeAction.setRawData(qrCodeActionRawData);
//                    qrCodeTag.setAction(qrCodeAction);
//                    tags.add(qrCodeTag);
//                    titleBody.setTags(tags);
                    break;
                case MapAddress.COMPONENT_TYPE:
                    pageData.put(schema, MapAddress.create(schema, transportMainInfo, localeService, locale));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    buildCard(card, locale, transportNo, transportMainInfo);
                    pageData.put(schema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = new CustomGroup();
                    if ("CUSTOM_GROUP_LOGISTICS".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, transportMainInfo,
                                JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class), false);
                    } else if ("cargoInformation".equalsIgnoreCase(schema)) {
                        UiBotModel customUiboModel = JsonUtil.objectToJavaObject(pageData.get(schema), UiBotModel.class);
                        List<UiBotLayout> uiBotLayoutList = customUiboModel.getLayout();
                        UiBotPageData customPageData = customUiboModel.getPageData();
                        for (UiBotLayout uiBotLayout : uiBotLayoutList) {
                            switch (uiBotLayout.getType()) {
                                case PageButton.COMPONENT_TYPE:
                                    PageButton pageButton = new PageButton();
                                    pageButton.setName(localeService.getLanguageValue(locale, customUiboModel.getName()));
                                    Action pageButtonAction = JsonUtil.objectToJavaObject(customPageData.get("action"), Action.class);
                                    pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                                    pageButtonAction.setDataId(transportNo);
                                    pageButton.setAction(pageButtonAction);
                                    customPageData.put(uiBotLayout.getSchema(), pageButton);
                                    break;
                                default:
                                    break;
                            }
                        }
                        CustomGroupContent content = new CustomGroupContent();
                        content.setLayout(uiBotLayoutList);
                        content.setPageData(customPageData);
                        customGroup.setContent(content);
                        customGroup.setHiddenConfig(new HiddenConfig());
                        customGroup.setUseExpand(false);
                        customGroup.setHasDetail(false);
                    }
                    pageData.put(schema, customGroup);
                    break;
                case PageButton.COMPONENT_TYPE:
                    PageButton pageButton = JsonUtil.objectToJavaObject(pageData.get(schema), PageButton.class);
                    pageButton.setName(localeService.getLanguageValue(locale, pageButton.getName()));
                    Action pageButtonAction = pageButton.getAction();
                    if ("cargoInformation".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        pageButtonAction.setDataId(transportNo);
                    } else if ("shippingSchedule".equalsIgnoreCase(schema)) {
                        pageButtonAction.setJumpPageTitle(localeService.getLanguageValue(locale, pageButtonAction.getJumpPageTitle()));
                        Map<String, Object> params = new HashMap<>(1);
                        params.put("module_type", "2");
                        String url = digiwinEspProxyService.getSrmLoadingWebUrl(iamUserToken, tenantId, locale, params) + "&userId=" + apiRequest.getUserId();
                        pageButtonAction.setRequestUrl(url);
                    }
                    pageButton.setAction(pageButtonAction);
                    pageData.put(schema, pageButton);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    String arrivalStatus = StrUtil.isBlank(transportMainInfo.getArrivalStatus()) ? "0" : transportMainInfo.getArrivalStatus();
                    BottomButtonList newBottomButtonList = new BottomButtonList();
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        Action action = bottomButtonDigiwinAthena.getAction();
                        if (action != null) {
                            if (action.getConfirmPop() != null && StringUtils.hasLength(action.getConfirmPop().getContent())) {
                                action.getConfirmPop().setContent(localeService.getLanguageValue(locale, action.getConfirmPop().getContent()));
                            } else if (StringUtils.hasLength(action.getJumpPageTitle())) {
                                action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                        }
                        Map<String, Object> buttonRawData = new HashMap<>();
                        if (action.getRawData() != null) {
                            buttonRawData = (Map<String, Object>) action.getRawData();
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                        //rawData里存提交接口所需参数
                        UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            Map<String, Object> data = new HashMap<>();
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                            buttonRawData.put("data", data);
                        }
                        action.setRawData(buttonRawData);

                        List<BottomButtonDigiwinAthena> children = bottomButtonDigiwinAthena.getChildren();
                        if (!CollectionUtils.isEmpty(children)) {
                            for (BottomButtonDigiwinAthena button : children) {
                                if (StringUtils.hasLength(button.getName())) {
                                    button.setName(localeService.getLanguageValue(locale, button.getName()));
                                }
                                if (StringUtils.hasLength(button.getSubName())) {
                                    button.setSubName(localeService.getLanguageValue(locale, button.getSubName()));
                                }
                                Action action1 = button.getAction();
                                if (action1 != null) {
                                    if (StringUtils.hasLength(action1.getJumpPageTitle())) {
                                        action1.setJumpPageTitle(localeService.getLanguageValue(locale, action1.getJumpPageTitle()));
                                    }
                                    if (StringUtils.hasLength(action1.getToastMsg())) {
                                        action1.setToastMsg(localeService.getLanguageValue(locale, action1.getToastMsg()));
                                    }
                                    Map<String, Object> childButtonRawData = new HashMap<>();
                                    if (action1.getRawData() != null) {
                                        childButtonRawData = (Map<String, Object>) action1.getRawData();
                                    }
                                    childButtonRawData.put("transport_no", transportNo);
                                    childButtonRawData.put("task_no", taskNo);
                                    childButtonRawData.put("digi-proxy-token", digiwinAtmcBacklogDetail.getProxyToken());
                                    if (StrUtil.equals(StrUtil.toString(childButtonRawData.get("action_id")), "receive_scan")) {
                                        QrCodeContentMsg qrCodeContentMsg = new QrCodeContentMsg(QrCodeContentMsg.BIZ_TYPE_TRANSPORT_RECEIVE);
                                        qrCodeContentMsg.put("transport_no", transportNo);
                                        QrCode qrCode = QrCode.create(qrCodeContentMsg, LocaleUtil.getMobileTextByKey(locale, "请扫描运单二维码"));
                                        childButtonRawData.put("qrCode", qrCode);
                                    }
                                    if (null != uiBotAction) {
                                        childButtonRawData.put("action", uiBotAction);
                                        Map<String, Object> data = new HashMap<>();
                                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                                        data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                                        childButtonRawData.put("data", data);
                                    }
                                    action1.setRawData(childButtonRawData);
                                }
                                setRequestUrl(button);
                            }
                        }

                        if (ObjectUtil.isNotEmpty(buttonRawData.get("action_id"))) {
                            if (StrUtil.equals(StrUtil.toString(buttonRawData.get("action_id")), "transport_arrival")) {
                                if (StrUtil.equals(arrivalStatus, "0")) {
                                    newBottomButtonList.add(bottomButtonDigiwinAthena);
                                }
                            } else if (StrUtil.equals(StrUtil.toString(buttonRawData.get("action_id")), "transport_receive")) {
                                if (StrUtil.equals(arrivalStatus, "1")) {
                                    newBottomButtonList.add(bottomButtonDigiwinAthena);
                                }
                            } else {
                                newBottomButtonList.add(bottomButtonDigiwinAthena);
                            }
                        } else {
                            newBottomButtonList.add(bottomButtonDigiwinAthena);
                        }
                    });
                    pageData.put(schema, newBottomButtonList);
                    break;
                default:
                    break;
            }
        }
        //查询司机消息
        Map<String, Object> params = new HashMap<>();
        params.put("transport_no", transportNo);
        List<Map<String, Object>> msgList = digiwinEspProxyService.getTransportDriverMsg(iamUserToken, tenantId, locale, params);
        if (ObjectUtil.isNotEmpty(msgList) && msgList.size() > 0) {
            Optional<Map<String, Object>> msgOptional1 = msgList.stream().filter(o -> StrUtil.equals("1", StrUtil.toString(o.get("msg_type")))).findFirst();
            if (msgOptional1.isPresent()) {
                uiBotModel.setShowStartPosition(true);
            } else {
                uiBotModel.setShowStartPosition(false);
            }
            List<Map<String, Object>> list = msgList.stream().filter(o -> !StrUtil.equals("1", StrUtil.toString(o.get("msg_type")))).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(list) && list.size() > 0) {
                Map<String, Object> map = list.get(0);
                Action action = new Action();
                UiBotAction uiBotAction = getSubmitAction(pcUiBotModel, "submit-data");

                if (StrUtil.equals("3", StrUtil.toString(map.get("msg_type")))) {
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_STOP_ABNORMAL_ALARM.name());
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, "长时间停留预警"));
                    Map<String, Object> rawData = new HashMap<>();
                    rawData.put("action_id", "stop");
                    rawData.put("transport_no", transportNo);
                    rawData.put("task_no", taskNo);
                    if (null != uiBotAction) {
                        rawData.put("action", uiBotAction);
                        Map<String, Object> data = new HashMap<>();
                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                        rawData.put("data", data);
                    }
                    action.setRawData(rawData);
                }
                if (StrUtil.equals("2", StrUtil.toString(map.get("msg_type")))) {
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_SHIFTING_ABNORMAL_ALARM.name());
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, "偏移预警"));
                    Map<String, Object> rawData = new HashMap<>();
                    rawData.put("action_id", "shifting");
                    rawData.put("transport_no", transportNo);
                    rawData.put("task_no", taskNo);
                    if (null != uiBotAction) {
                        rawData.put("action", uiBotAction);
                        Map<String, Object> data = new HashMap<>();
                        String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                        data.put(actionDataScheme, pcUiBotModel.getPageData().get(actionDataScheme));
                        rawData.put("data", data);
                    }
                    action.setRawData(rawData);
                }
                log.debug("beforeAction:" + JSONUtil.toJsonStr(action));
                uiBotModel.setBeforeAction(action);
            }
        }
        log.debug("uiBotModel:" + JSONUtil.toJsonStr(uiBotModel));
        return uiBotModel;
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || !StringUtils.hasLength(action.getRequestUrl())) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    /**
     * 构造Card
     *
     * @param card
     * @param locale
     * @param transportNo
     * @param transportMainInfo
     */
    private void buildCard(Card card, String locale, String transportNo, DigiwinTransportResponse transportMainInfo) {
        if (StringUtils.hasLength(card.getTitle())) {
            card.setTitle(localeService.getLanguageValue(locale, card.getTitle()));
        }
        List<CardContent> contentList = card.getContent();
        if (!CollectionUtils.isEmpty(contentList)) {
            Map<String, Object> transportMainInfoMap = JsonUtil.objectToJavaObject(transportMainInfo, Map.class);
            contentList.forEach(cardContent -> {
                if (StringUtils.hasLength(cardContent.getLabel())) {
                    cardContent.setLabel(localeService.getLanguageValue(locale, cardContent.getLabel()));
                }
                String schema = cardContent.getSchema();
                if ("transport_no".equalsIgnoreCase(schema)) {
                    //运单号
                    cardContent.setValue(transportNo);
                } else if ("appoint_time".equalsIgnoreCase(schema)) {
                    //预约送货日期
                    String date = StringUtils.hasLength(transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                    String[] values = date.split(" ");
                    String value = "";
                    if (values.length > 1) {
                        value = values[0];
                    } else {
                        value = date;
                    }
                    cardContent.setValue(value);
                } else if ("time_slot".equalsIgnoreCase(schema)) {
                    //预约送货时段
                    List<TimeSlot> timeSlots = transportMainInfo.getTimeSlot();
                    if (timeSlots != null && timeSlots.size() > 0) {
                        cardContent.setValue(transportMainInfo.getTimeSlots(timeSlots));
                    }
                } else {
                    cardContent.setValue((String) transportMainInfoMap.get(schema));
                }
            });
        }

    }


    private UiBotAction getSubmitAction(UiBotModel pcUiBotModel, String actionId) {
        List<UiBotLayout> layoutList = pcUiBotModel.getLayout();
        if (CollectionUtils.isEmpty(layoutList)) {
            return null;
        }
        AtomicReference<UiBotAction> uiBotAction = new AtomicReference<>();
        outer:
        for (UiBotLayout layout : layoutList) {
            List<UiBotAction> actions = layout.getActions();
            if (CollectionUtils.isEmpty(actions)) {
                continue;
            }
            for (UiBotAction action : actions) {
                if (actionId.equalsIgnoreCase(action.getActionId())) {
                    uiBotAction.set(action);
                    break outer;
                }
            }
        }
        return uiBotAction.get();
    }

}
