package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

/**
 * 运输在途-转运车辆页面
 *
 * @author zhangjj
 * @date 2022/12/16 15:04
 */
@Component
public class UiBotModelBuildZTBTransportVehicleInfoStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        ZTBDriverVehicle vehicleInfo = JsonUtil.objectToJavaObject(rawData.get("vehicle_info"), ZTBDriverVehicle.class);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case GraphicDisplay.COMPONENT_TYPE:
                    pageData.put(schema, GraphicDisplay.createNoSubTitle(vehicleInfo, 1, digiwinDmcProxyService));
                    break;
//                case Field.COMPONENT_TYPE:
//                    Field field = JsonUtil.objectToJavaObject(pageData.get(schema), Field.class);
//                    if (!StringUtils.hasLength(field.getValue())) {
//                        field.setValue((String) vehicleInfo.get(schema));
//                    } else {
//                        //车辆信息多语言
//                        field.setValue(LocaleUtil.getMobileTextByKey(locale, field.getValue()));
//                    }
//                    field.setLabel(LocaleUtil.getMobileTextByKey(locale, field.getLabel()));
//                    pageData.put(schema, field);
//                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                        if (ActionTypeEnum.CALL_API_BACK_INDEX.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get("transport_no"));
                            buttonRawData.put("vehicle_info_id", vehicleInfo.getVehicleInfoId() == null ? vehicleInfo.getId() : vehicleInfo.getVehicleInfoId());
                            buttonRawData.put("biz_id", "ZTB");
                            buttonRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString());
                            buttonRawData.put("action", rawData.get("action"));
                            buttonRawData.put("data", rawData.get("data"));
                            action.setRawData(buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }
}
