package com.digiwin.mobile.mobileuibot.push.fcm.service;

import com.digiwin.mobile.mobileuibot.push.fcm.model.FcmMobileUserVo;

import java.util.List;

public interface FcmService {

    /**
     * 通过userId和deviceId找到对应记录
     *
     * @param userId
     * @param deviceId
     * @return
     */
    FcmMobileUserVo getFcmMobileUser(String userId, String deviceId);

    /**
     * 新增设备的fcm的token
     *
     * @param fcmMobileUserVo
     * @return
     */
    Boolean addFcmMobileUser(FcmMobileUserVo fcmMobileUserVo);

    /**
     * 删除设备fcm的记录
     *
     * @param userId
     * @param deviceId
     * @param fcmToken
     * @return
     */
    Boolean deleteFcmMobileUser(String userId, String deviceId, String fcmToken);

    /**
     * 获取用户fcm token集合
     *
     * @param userIds
     * @param tenantId
     * @return
     */
    List<String> getFcmUserTokenList(List<String> userIds, String tenantId);
}
