package com.digiwin.mobile.mobileuibot.push.fcm.service.impl;

import com.digiwin.mobile.mobileuibot.mapper.db1.FcmMobileUserMapper;
import com.digiwin.mobile.mobileuibot.model.db1.FcmMobileUser;
import com.digiwin.mobile.mobileuibot.push.fcm.model.FcmMobileUserVo;
import com.digiwin.mobile.mobileuibot.push.fcm.service.FcmService;
import lombok.Synchronized;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Service("fcmService")
public class FcmServiceImpl implements FcmService {

    @Autowired
    private FcmMobileUserMapper fcmMobileUserMapper;

    @Override
    public FcmMobileUserVo getFcmMobileUser(String userId, String deviceId) {
        FcmMobileUserVo fcmMobileUserVo = new FcmMobileUserVo();
        Map<String, String> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("deviceId", deviceId);
        FcmMobileUser fcmMobileUser = fcmMobileUserMapper.getByMap(params);
        if (fcmMobileUser != null) {
            BeanUtils.copyProperties(fcmMobileUserMapper.getByMap(params), fcmMobileUserVo);
            return fcmMobileUserVo;
        } else {
            return null;
        }
    }

    @Synchronized
    @Override
    public Boolean addFcmMobileUser(FcmMobileUserVo fcmMobileUserVo) {
        FcmMobileUser fcmMobileUser = new FcmMobileUser();
        FcmMobileUserVo oldFcmMobileUserVo = getFcmMobileUser(fcmMobileUserVo.getUserId(), fcmMobileUserVo.getDeviceId());
        if (oldFcmMobileUserVo != null) {
            return true;
        }
        BeanUtils.copyProperties(fcmMobileUserVo, fcmMobileUser);
        fcmMobileUser.setDeleteToken(0);
        fcmMobileUser.setCreateTime(new Date(System.currentTimeMillis()));
        return fcmMobileUserMapper.insert(fcmMobileUser) > 0;
    }

    @Override
    public Boolean deleteFcmMobileUser(String userId, String deviceId, String fcmToken) {
        Map<String, String> params = new HashMap<>(3);
        params.put("userId", userId);
        params.put("deviceId", deviceId);
        params.put("fcmToken", fcmToken);
        return fcmMobileUserMapper.deleteToken(params);
    }

    @Override
    public List<String> getFcmUserTokenList(List<String> userIds, String tenantId) {
        return fcmMobileUserMapper.getFcmUserTokenList(userIds, tenantId);
    }
}
