package com.digiwin.mobile.mobileuibot.recommend;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntrance;

import java.util.List;

/**
 * <p>功能描述：推荐服务（基于固定的逻辑和既定的配置）</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendService
 * @Author: Zaregoto
 * @Date: 2022/3/13 22:38
 */
public interface RecommendService {

    //常用应用最大个数
    int COMMON_APP_NUM = 4;

    //todo

    /**
     * 获取推荐的应用入口
     *
     * @param iamUserToken
     * @param userId
     * @param locale
     * @return
     */
    List<AppFunctionTouchable> getRecommendAppList(ApiRequest apiRequest);

    /**
     * 获取所以=有应用，返回应用入口组件
     *
     * @param iamUserToken
     * @param userId
     * @param locale
     * @return
     */
    List<AppEntrance> getAllAppEntrance(String iamUserToken, String userId, String locale);

}
