package com.digiwin.mobile.mobileuibot.recommend;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.*;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import com.digiwin.mobile.mobileuibot.recommend.rule.*;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsParam;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * <p>功能描述：推荐服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendServiceImpl
 * @Author: Zaregoto
 * @Date: 2022/3/13 22:43
 */
@Slf4j
@Service("recommendService")
public class RecommendServiceImpl implements RecommendService {

    private static final String DASHBOARD_VERSION_V2 = "v2";

    @Autowired
    private RecommendRuleService recommendRuleService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private AppEntranceRecordService appEntranceRecordService;

    @Autowired
    private DashBoardService dshboardService;

    @Autowired
    private LocaleService localeService;

    @Override
    public List<AppFunctionTouchable> getRecommendAppList(ApiRequest apiRequest) {
        String userId = apiRequest.getUserId();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        List<AppFunctionTouchable> appList = new ArrayList<>();

        boolean isv2 = Objects.equals(DASHBOARD_VERSION_V2, apiRequest.getDashboardVersion());

        // 获取所有可用应用清单
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        //todo 20240429 待处理，得修改 金刚区不要在去查库，应在工作台点击某个应用固定的参数存到表里，这里获取使用，不去调用第三方接口获取
        //todo 这边2个接口可以优化为1个接口：http://172.16.2.141:22694/html/web/controller/share/share.html#64549ecdeae133071b1a7c5d
        List<String> goodsCodes =
                this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(
                        analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (CollectionUtils.isEmpty(goodsCodes)) {
            return Collections.emptyList();
        }
        List<String> commonAppIdList = appEntranceRecordService.getAppIdListByUserId(userId, analyzedToken.getTenantId());
        if (CollectionUtils.isEmpty(commonAppIdList)) {
            return appList;
        }
        // FIXME 先用于“猜你想做”的场景，后续再看如何扩展
        List<String> list = new ArrayList<>(2);
        list.add(RecommendRuleCategoryEnum.GUESS_WHAT_YOU_WANT_TO_DO.getValue());
        list.add(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        List<RecommendRule> recommendRules = this.recommendRuleService
                .findRuleByCategoryList(list);
        // 购买规则
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream()
                .filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()))
                .sorted(Comparator.comparingInt(RecommendRule::getOrder))
                .collect(Collectors.toList());
        //不需要校验的appCode
        List<String> notVerifyAppCodeList = new ArrayList<>();
        // 配置的规则和实际查询出来的购买情况做比对，只有实际购买过才能在App看到
        List<AppFunctionTouchable> hasRecommendPermissionAppList = new ArrayList<>();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = JsonUtil.objectToJavaObject(pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }
            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream()
                    .anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode)
                            // 配置中用Athena表示所有用户均可用的功能
                            || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    // 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    //数据录入从智能入口拿出来作为一个单独模块
                    if (isv2 && "BASIC_DATA_ENTRANCE".equals(moduleId)) {
                        return;
                    }

                    //发起项目单独判断是否有权限（需要根据里面的作业来判断）
                    if("Athena_LAUNCH_PROJECT".equals(moduleId)){
                        return;
                    }

                    boolean moduleEnableInFact = true;
                    if (verify) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            // 人员状态入口需要根据作业id判断是否有展示权限
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(
                                    analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId,
                                    iamUserToken);
                        }
                    } else {
                        notVerifyAppCodeList.add(pgrrGoodsCode + "_" + moduleId);
                    }
                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        // FIXME 这种必须手动写的动作是否可以封装起来，以免遗漏
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId())
                                    .replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid()))
                                    .replace("{tenantName}", analyzedToken.getTenantName())
                                    .replace("{userId}", analyzedToken.getId())
                                    .replace("{userName}", analyzedToken.getName())
                                    .replace("{token}", iamUserToken)
                                    .replace("{locale}",locale);
                        }
                        if (StringUtils.hasLength(requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        // FIXME 从配置对象转换为最终的目标对象。是否需要考虑另一种写法：既简化传参，也减少recommend package与core package之间的耦合
                        AppFunctionTouchable appTouchable = AppFunctionTouchable
                                .create(LocaleUtil.getMobileTextByKey(locale, mobileConfig.getName()), mobileConfig.getIconData(),
                                        mobileConfig.getIconColor(),
                                        mobileConfig.getAction().getJumpPageId(),
                                        mobileConfig.getAction().getJumpPageTitle(),
                                        mobileConfig.getAction().getType(),
                                        requestUrl,
                                        mobileConfig.getImage(),mobileConfig.getImageUrl());
                        AppEntranceAccessRecord accessRecord = mobileConfig.getAccessRecord();
                        if (accessRecord != null
                                && accessRecord.getSendRecord() != null
                                && accessRecord.getSendRecord()) {
                            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
                            appTouchable.setAccessRecord(accessRecord);
                        }
                        appTouchable.setId(pgrrGoodsCode + "_" + moduleId);
                        // 转换结果加到目标list中
                        hasRecommendPermissionAppList.add(appTouchable);
                    }
                });
            }
        });

        // TODO 权限规则

        // TODO 用户规则

        // TODO 场景规则

        // TODO 客观规则

        List<String> copyCommonAppIdList = JsonUtil.objectToJavaObject(commonAppIdList, new TypeReference<List<String>>() {
        });

        //智能推荐
        if (!CollectionUtils.isEmpty(hasRecommendPermissionAppList)) {
            Map<String, AppFunctionTouchable> hasRecommendPermissionAppListMapById = hasRecommendPermissionAppList.stream().collect(Collectors.toMap(AppFunctionTouchable::getId, app -> app, (a, b) -> a));
            List<AppFunctionTouchable> newRecommendAppList = commonAppIdList.stream().filter(appId -> hasRecommendPermissionAppListMapById.containsKey(appId))
                    .map(appId -> hasRecommendPermissionAppListMapById.get(appId)).collect(Collectors.toList());
            appList.addAll(newRecommendAppList);
            commonAppIdList.removeAll(hasRecommendPermissionAppListMapById.keySet());
        }

        //发起项目问题
        if (!CollectionUtils.isEmpty(commonAppIdList)) {
            List<AppFunctionTouchable> launchableProjectAppList = projectService.getLaunchableProjectAppList(iamUserToken, userId, locale);
            if (!CollectionUtils.isEmpty(launchableProjectAppList)) {
                Map<String, AppFunctionTouchable> launchableProjectAppListMapById = launchableProjectAppList.stream().collect(Collectors.toMap(AppFunctionTouchable::getId, app -> app, (a, b) -> a));
                List<AppFunctionTouchable> newLaunchableProjectAppList = commonAppIdList.stream().filter(appId -> launchableProjectAppListMapById.containsKey(appId))
                        .map(appId -> launchableProjectAppListMapById.get(appId)).collect(Collectors.toList());
                appList.addAll(newLaunchableProjectAppList);
                commonAppIdList.removeAll(launchableProjectAppListMapById.keySet());
            }
        }

        //数据录入
        if (!CollectionUtils.isEmpty(commonAppIdList) && isv2) {
            List<AppModuleItem> appModuleItemList = dshboardService.getDataEntryModuleList(apiRequest.getClientId(), iamUserToken, analyzedToken.getTenantId(), locale);
            if (!CollectionUtils.isEmpty(appModuleItemList)) {
                List<AppFunctionTouchable> dataEntryAppList = JsonUtil.objectToJavaObject(appModuleItemList, new TypeReference<List<AppFunctionTouchable>>() {
                });
                Map<String, AppFunctionTouchable> dataEntryAppMapById = dataEntryAppList.stream().collect(Collectors.toMap(AppFunctionTouchable::getId, app -> app, (a, b) -> a));
                List<AppFunctionTouchable> newDataEntryAppList = commonAppIdList.stream().filter(appId -> dataEntryAppMapById.containsKey(appId))
                        .map(appId -> dataEntryAppMapById.get(appId)).collect(Collectors.toList());
                appList.addAll(newDataEntryAppList);
            }
        }

        //按照原先的顺序排序
        appList = appList.stream()
                .sorted(Comparator.comparingInt(item -> copyCommonAppIdList.indexOf(item.getId())))
                .collect(Collectors.toList());

        if (appList.size() > COMMON_APP_NUM) {
            //最多展示4个应用入口
            appList = appList.subList(0, COMMON_APP_NUM);
        }
        return appList;
    }

//    @Override
//    public List<AppEntrance> getAllAppEntrance(String iamUserToken, String userId, String locale) {
//        // 获取所有可用应用清单
//        DigiwinIamAnalyzedToken analyzedToken =
//                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
//        List<String> goodsCodes =
//                this.digiwinCacProxyService.findAuthorizationsByUserIdAndTenantId(
//                        analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
//        if (goodsCodes.isEmpty()) {
//            return Collections.emptyList();
//        }
//        List<RecommendRule> recommendRules = this.recommendRuleService
//                .findRuleByCategory(RecommendRuleCategoryEnum.GUESS_WHAT_YOU_WANT_TO_DO.getValue());
//        // 购买规则
//        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream()
//                .filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()))
//                .sorted(Comparator.comparingInt(RecommendRule::getOrder))
//                .collect(Collectors.toList());
//        // 配置的规则和实际查询出来的购买情况做比对，只有实际购买过才能在App看到
//        List<AppEntrance> appEntranceList = new ArrayList<>();
//        purchasedGoodsRecommendRules.forEach(pgrr -> {
//            PurchasedGoodsParam param = JsonUtil.objectToJavaObject(pgrr.getParams(), PurchasedGoodsParam.class);
//            if (null == param) {
//                return;
//            }
//            AppEntrance appEntrance = new AppEntrance();
//            appEntrance.setTitle(param.getGoodsDisplayName());
//            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
//            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
//            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());
//            List<AppFunctionTouchable> appList = new ArrayList<>();
//            String pgrrGoodsCode = param.getGoodsCode();
//            boolean goodsPurchasedInFact = goodsCodes.stream()
//                    .anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode));
//            if (goodsPurchasedInFact && null != param.getEnableModules()) {
//                param.getEnableModules().forEach(module -> {
//                    String moduleId = module.getModuleId();
//                    boolean moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(
//                            analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId,
//                            iamUserToken);
//                    if (moduleEnableInFact) {
//                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
//                        // FIXME 这种必须手动写的动作是否可以封装起来，以免遗漏
//                        mobileConfig.initSetting(locale);
//                        String requestUrl = mobileConfig.getAction().getRequestUrl();
//                        if (StringUtils.hasLength(requestUrl) && !requestUrl.startsWith("http")) {
//                            requestUrl = AppContext.getBaseUrl() + requestUrl;
//                        }
//                        // FIXME 从配置对象转换为最终的目标对象。是否需要考虑另一种写法：既简化传参，也减少recommend package与core package之间的耦合
//                        AppFunctionTouchable appTouchable = AppFunctionTouchable
//                                .create(mobileConfig.getName(), mobileConfig.getIconData(),
//                                        mobileConfig.getIconColor(),
//                                        mobileConfig.getAction().getJumpPageId(),
//                                        mobileConfig.getAction().getJumpPageTitle(),
//                                        mobileConfig.getAction().getType(),
//                                        requestUrl,
//                                        mobileConfig.getImage());
//                        AppEntranceAccessRecord accessRecord = mobileConfig.getAccessRecord();
//                        if (accessRecord != null
//                                && accessRecord.getSendRecord() != null
//                                && accessRecord.getSendRecord()) {
//                            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
//                            appTouchable.setAccessRecord(accessRecord);
//                        }
//                        appTouchable.setId(pgrrGoodsCode + "_" + moduleId);
//                        // 转换结果加到目标list中
//                        appList.add(appTouchable);
//                    }
//                });
//            }
//            if (appList.isEmpty()) {
//                return;
//            }
//            appEntrance.setAppList(appList);
//            appEntranceList.add(appEntrance);
//        });
//        return appEntranceList;
//    }

    @Override
    public List<AppEntrance> getAllAppEntrance(String iamUserToken, String userId, String locale) {
        // 获取所有可用应用清单
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List<String> goodsCodes =
                this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(
                        analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }
        List<RecommendRule> recommendRules = this.recommendRuleService
                .findRuleByCategory(RecommendRuleCategoryEnum.APP_SERVER_ENTRANCE.getValue());
        // 购买规则
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream()
                .filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()))
                .sorted(Comparator.comparingInt(RecommendRule::getOrder))
                .collect(Collectors.toList());
        // 配置的规则和实际查询出来的购买情况做比对，只有实际购买过才能在App看到
        AppEntrance appEntrance = new AppEntrance();
        List<AppFunctionTouchable> appList = new ArrayList<>();
        purchasedGoodsRecommendRules.forEach(pgrr -> {
            PurchasedGoodsParam param = JsonUtil.objectToJavaObject(pgrr.getParams(), PurchasedGoodsParam.class);
            if (null == param) {
                return;
            }
            appEntrance.setTitle(localeService.getLanguageValue(locale, param.getGoodsDisplayName()));
            appEntrance.setAppLayoutType(AppEntranceLayoutTypeEnum.EQUAL_RATION.getValue());
            appEntrance.setDirection(AppEntranceDirectionEnum.HORIZONTAL.getValue());
            appEntrance.setTitleStyle(AppEntranceTitleStyleEnum.TITLE_BOLD.getValue());

            String pgrrGoodsCode = param.getGoodsCode();
            boolean goodsPurchasedInFact = goodsCodes.stream()
                    .anyMatch(goodsCode -> Objects.equals(goodsCode, pgrrGoodsCode)
                            // 配置中用Athena表示所有用户均可用的功能
                            || "Athena".equalsIgnoreCase(pgrrGoodsCode));
            if (goodsPurchasedInFact && null != param.getEnableModules()) {
                param.getEnableModules().forEach(module -> {
                    // 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
                    module.convert();
                    Boolean valid = Optional.ofNullable(module.getValid()).orElse(false);
                    Boolean verify = Optional.ofNullable(module.getVerify()).orElse(true);
                    if (!valid) {
                        return;
                    }
                    String moduleId = module.getModuleId();
                    boolean moduleEnableInFact = true;
                    if (verify) {
                        if ("APC".equals(pgrrGoodsCode)) {
                            // 人员状态入口需要根据作业id判断是否有展示权限
                            if ("PERSONNEL_ONLINE".equals(module.getModuleId()) || "STAND_PRODUCTION_PROGRESS".equals(module.getModuleId())) {
                                moduleEnableInFact = isMatchWorkId(userId, pgrrGoodsCode, iamUserToken, module);
                            }
                        } else {
                            moduleEnableInFact = this.digiwinCacProxyService.useModuleByTenantIdAndUserId(
                                    analyzedToken.getTenantId(), analyzedToken.getId(), pgrrGoodsCode, moduleId,
                                    iamUserToken);
                        }
                    }

                    if (moduleEnableInFact) {
                        RecommendMobileConfig mobileConfig = module.getMobileConfig();
                        mobileConfig.initSetting(locale);
                        String requestUrl = mobileConfig.getAction().getRequestUrl();
                        if ("ChatFile".equalsIgnoreCase(mobileConfig.getName()) || "trmnana".equals(param.getGoodsCode())) {
                            requestUrl = requestUrl.replace("{tenantId}", analyzedToken.getTenantId())
                                    .replace("{tenantSid}", String.valueOf(analyzedToken.getTenantSid()))
                                    .replace("{tenantName}", analyzedToken.getTenantName())
                                    .replace("{userId}", analyzedToken.getId())
                                    .replace("{userName}", analyzedToken.getName())
                                    .replace("{token}", iamUserToken)
                                    .replace("{locale}",locale);
                        }
                        if (StringUtils.hasLength(requestUrl) && !requestUrl.startsWith("http")) {
                            requestUrl = AppContext.getBaseUrl() + requestUrl;
                        }
                        AppFunctionTouchable appTouchable = AppFunctionTouchable
                                .create(mobileConfig.getName(), mobileConfig.getIconData(),
                                        mobileConfig.getIconColor(),
                                        mobileConfig.getAction().getJumpPageId(),
                                        mobileConfig.getAction().getJumpPageTitle(),
                                        mobileConfig.getAction().getType(),
                                        requestUrl,
                                        mobileConfig.getImage(),mobileConfig.getImageUrl());
                        appTouchable.getAction().setDataId(mobileConfig.getAction().getDataId());
                        AppEntranceAccessRecord accessRecord = mobileConfig.getAccessRecord();
                        if (accessRecord != null
                                && accessRecord.getSendRecord() != null
                                && accessRecord.getSendRecord()) {
                            accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
                            appTouchable.setAccessRecord(accessRecord);
                        }
                        appTouchable.setId(pgrrGoodsCode + "_" + moduleId);
                        // 转换结果加到目标list中
                        appList.add(appTouchable);
                    }
                });
            }
        });
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        appEntrance.setAppList(appList);
        return Collections.singletonList(appEntrance);
    }

    /**
     * 判断作业id是否匹配
     *
     * @param userId
     * @param pgrrGoodsCode
     * @param iamUserToken
     * @param module
     * @return
     */
    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;

        Optional optional = Optional.ofNullable(userPermission)
                .map(DigiwinIamUserAuthInfo::getResult)
                .map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent()) {
            if (userPermission != null && userPermission.getResult() != null) {
                isMatchWorkId = userPermission.getResult().getPermissions().
                        stream().anyMatch(e -> e.getId().equals(module.getWorkId())
                                && "allow".equalsIgnoreCase(e.getEffect()));
            }

        }
        return isMatchWorkId;
    }

    /**
     * 获取所有应用
     *
     * @param iamUserToken
     * @return
     */
    private List<RecommendRule> getRecommendRuleList(String iamUserToken) {
        // 获取所有可用应用清单
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        List<String> goodsCodes =
                this.digiwinCacProxyService.findAuthorizationsEnabledByUserIdAndTenantId(
                        analyzedToken.getTenantId(), analyzedToken.getId(), iamUserToken);
        if (goodsCodes.isEmpty()) {
            return Collections.emptyList();
        }

        // FIXME 先用于“猜你想做”的场景，后续再看如何扩展
        List<RecommendRule> recommendRules = this.recommendRuleService
                .findRuleByCategory(RecommendRuleCategoryEnum.GUESS_WHAT_YOU_WANT_TO_DO.getValue());
        // 购买规则
        List<RecommendRule> purchasedGoodsRecommendRules = recommendRules.stream()
                .filter(rr -> Objects.equals(rr.getParamsType(), RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()))
                .collect(Collectors.toList());
        return purchasedGoodsRecommendRules;
    }
}