package com.digiwin.mobile.mobileuibot.recommend.appentrancerecord;

import cn.hutool.core.date.DateUtil;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.model.db1.AppEntranceRecord;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;

/**
 * 应用入口访问记录API
 *
 * @author zhangjj
 * @date 2022/11/29 10:54
 */
@RestController
@RequestMapping(value = "/mobile/v1/appEntranceRecord")
public class AppEntranceRecordController {

    @Autowired
    private AppEntranceRecordService appEntranceRecordService;


    /**
     * 新增应用入口访问记录
     *
     * @param request
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/add")
    public ApiResponse addAppEntrance(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String appId = (String) params.get("appId");
        String tenantId = (String) params.get("tenantId");
        String userId = (String) params.get("userId");
        AppEntranceRecord appEntranceRecord = new AppEntranceRecord();
        appEntranceRecord.setUserId(userId);
        appEntranceRecord.setTenantId(tenantId);
        appEntranceRecord.setAppId(appId);
        appEntranceRecord.setDate(DateUtil.date());
        appEntranceRecordService.addAppEntrance(appEntranceRecord);
        return ApiResponse.buildOK();
    }

}
