package com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service;

import com.digiwin.mobile.mobileuibot.model.db1.AppEntranceRecord;

import java.util.List;

/**
 * 应用入口访问记录Service
 *
 * @author zhangjj
 * @date 2022/11/29 10:31
 */
public interface AppEntranceRecordService {

    /**
     * 新增应用入口访问记录
     *
     * @param appEntranceRecord
     */
    void addAppEntrance(AppEntranceRecord appEntranceRecord);

    /**
     * 根据用户id和租户id获取常用应用id
     *
     * @param userId
     * @return
     */
    List<String> getAppIdListByUserId(String userId, String tenantId);

    /**
     * 根据用户id和租户id获取报表常用应用id
     *
     * @param userId
     * @param tenantId
     * @return
     */
    List<String> getReportAppIdListByUserId(String userId, String tenantId);
}
