package com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.impl;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.mapper.db1.AppEntranceRecordMapper;
import com.digiwin.mobile.mobileuibot.model.db1.AppEntranceRecord;
import com.digiwin.mobile.mobileuibot.recommend.appentrancerecord.service.AppEntranceRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author zhangjj
 * @date 2022/11/29 10:33
 */
@Service
public class AppEntranceRecordServiceImpl implements AppEntranceRecordService {

    @Autowired
    private AppEntranceRecordMapper appEntranceRecordMapper;

    private final Object lockObj = new Object();
    //常用应用计算的天数（7天内）
    private static final int COMMON_APP_DAYS = 7;
    //常用应用计算的次数（超过7次为常用应用）
    private static final int COMMON_APP_COUNT = 7;

    @Override
    public void addAppEntrance(AppEntranceRecord appEntranceRecord) {
        if (!StringUtils.hasLength(appEntranceRecord.getAppId())
                || !StringUtils.hasLength(appEntranceRecord.getUserId())
                || !StringUtils.hasLength(appEntranceRecord.getTenantId())) {
            return;
        }
        synchronized (lockObj) {
            LambdaQueryWrapper<AppEntranceRecord> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(AppEntranceRecord::getUserId, appEntranceRecord.getUserId());
            wrapper.eq(AppEntranceRecord::getTenantId, appEntranceRecord.getTenantId());
            wrapper.eq(AppEntranceRecord::getDate, ((DateTime) appEntranceRecord.getDate()).toDateStr());
            wrapper.eq(AppEntranceRecord::getAppId, appEntranceRecord.getAppId());
            List<AppEntranceRecord> appEntranceRecords = appEntranceRecordMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(appEntranceRecords)) {
                appEntranceRecords.stream().filter(Objects::nonNull).forEachOrdered(existAppEntranceRecord -> {
                    existAppEntranceRecord.setCount(existAppEntranceRecord.getCount() + 1);
                    appEntranceRecordMapper.updateById(existAppEntranceRecord);
                });
            } else {
                appEntranceRecord.setRecordId(UUIDUtil.getUuid());
                appEntranceRecord.setCount(1);
                appEntranceRecordMapper.insert(appEntranceRecord);
            }
        }
    }

    @Override
    public List<String> getAppIdListByUserId(String userId, String tenantId) {
        List<String> appIdList = new ArrayList<>();
        //7天前，7天内访问7次以上可显示在首页
        String date = DateTime.of(System.currentTimeMillis() - COMMON_APP_DAYS * 24 * 60 * 60 * 1000).toDateStr();
        LambdaQueryWrapper<AppEntranceRecord> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppEntranceRecord::getUserId, userId);
        wrapper.eq(AppEntranceRecord::getTenantId, tenantId);
        wrapper.ge(AppEntranceRecord::getDate, date);
        wrapper.orderByDesc(AppEntranceRecord::getCount);
        List<AppEntranceRecord> appEntranceRecordList = appEntranceRecordMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(appEntranceRecordList)) {
            return appIdList;
        }
        Map<String, Integer> appIdCountMap = new HashMap<>();
        appEntranceRecordList.forEach(appEntranceRecord -> {
            //为你推荐去掉去掉行事历 这里是为了数据库里面的数据，不进行清楚做的防呆
            if (!"Athena_SCHEDULE".equalsIgnoreCase(appEntranceRecord.getAppId())
                    /*&& !appEntranceRecord.getAppId().contains("REPORT_")
                    && !"APC_PERSONNEL_ONLINE".equalsIgnoreCase(appEntranceRecord.getAppId())
                    && !appEntranceRecord.getAppId().contains("TipBiuBI_")*/) {
                if (appIdCountMap.containsKey(appEntranceRecord.getAppId())) {
                    Integer count = appIdCountMap.get(appEntranceRecord.getAppId());
                    appIdCountMap.put(appEntranceRecord.getAppId(), count + appEntranceRecord.getCount());
                } else {
                    appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount());
                }
            }
        });
        Set entries = appIdCountMap.entrySet();
        for (Iterator iterator = entries.iterator(); iterator.hasNext(); ) {
            Map.Entry entry = (Map.Entry) iterator.next();
            int i = (Integer) entry.getValue();
            if (i < COMMON_APP_COUNT) {
                iterator.remove();
            }
        }
        Map<String, Integer> map = MapUtil.sortMapDescOrderByValue(appIdCountMap);
        map.keySet().forEach(id -> appIdList.add(id));
        return appIdList;
    }

    @Override
    public List<String> getReportAppIdListByUserId(String userId, String tenantId) {
        List<String> appIdList = new ArrayList<>();
        LambdaQueryWrapper<AppEntranceRecord> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(AppEntranceRecord::getUserId, userId);
        wrapper.eq(AppEntranceRecord::getTenantId, tenantId);
        wrapper.ge(AppEntranceRecord::getAppId, "REPORT_%");
        wrapper.orderByDesc(AppEntranceRecord::getCount);
        List<AppEntranceRecord> appEntranceRecordList = appEntranceRecordMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(appEntranceRecordList)) {
            return appIdList;
        }
        Map<String, Integer> appIdCountMap = new HashMap<>(appEntranceRecordList.size());
        appEntranceRecordList.forEach(appEntranceRecord -> {
            Integer count = appIdCountMap.get(appEntranceRecord.getAppId());
            if (count != null && count != 0) {
                appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount() + count);
            } else {
                appIdCountMap.put(appEntranceRecord.getAppId(), appEntranceRecord.getCount());
            }

        });
        Map<String, Integer> map = MapUtil.sortMapDescOrderByValue(appIdCountMap);
        map.keySet().forEach(id -> appIdList.add(id));
        return appIdList;
    }
}
