package com.digiwin.mobile.mobileuibot.recommend.rule;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：推荐规则中移动的配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendMobileConfig
 * @Author: Zaregoto
 * @Date: 2022/3/13 21:22
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RecommendMobileConfig implements Serializable {
    private static final long serialVersionUID = 6183506967071080912L;

    private String name;
    private Integer iconData;
    private String iconColor;
    private Action action;
    private String image;
    private String imageUrl;
    private String imageFileId;
    private AppEntranceAccessRecord accessRecord;

    public void initSetting(String locale) {
        if (null != this.name) {
            this.name = LocaleUtil.getMobileTextByKey(locale, this.name);
        }
        if (null != this.action && null != this.action.getJumpPageTitle()) {
            String oldJumpTitle = this.action.getJumpPageTitle();
            this.action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, oldJumpTitle));
        }
        if (StringUtil.isNotEmpty(this.imageFileId)) {
            this.imageUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/Athena/preview/" + this.imageFileId;
        }
    }

    public void convert(RecommendMobileConfig mobileConfig) {
        if (null == mobileConfig) {
            return;
        }
        if (null != mobileConfig.getName()) {
            this.name = mobileConfig.getName();
        }
        if (null != mobileConfig.getIconData()) {
            this.iconData = mobileConfig.getIconData();
        }
        if (null != mobileConfig.getIconColor()) {
            this.iconColor = mobileConfig.getIconColor();
        }
        if (null != mobileConfig.getAction()) {
            if (null == this.action) {
                this.action = new Action();
            }
            this.action.convert(mobileConfig.getAction());
        }
        if (null != mobileConfig.getImage()) {
            this.image = mobileConfig.getImage();
        }
        if (null != mobileConfig.getImageFileId()) {
            this.imageFileId = mobileConfig.getImageFileId();
        }
        if (null != mobileConfig.getAccessRecord()) {
            if (null == this.accessRecord) {
                this.accessRecord = new AppEntranceAccessRecord();
            }
            this.accessRecord.convert(mobileConfig.getAccessRecord());
        }
    }
}
