package com.digiwin.mobile.mobileuibot.recommend.rule;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：移动推荐规则类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendRule
 * @Author: Zaregoto
 * @Date: 2022/3/13 20:23
 */
@Document(collection = "mobileRecommendRule")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RecommendRule implements Serializable {
    private static final long serialVersionUID = -4908319301305454499L;

    @Field("_id")
    private String id;
    /**
    * 配置是否有效
    */
    private Boolean valid;
    private String category;
    private String paramsType;
    private Map<String, Object> params;

    /**
     * 校验规则的排序。从0开始的自然数
     */
    private Integer order;
}
