package com.digiwin.mobile.mobileuibot.recommend.rule;

import java.util.Objects;

/**
 * <p>功能描述：移动推荐规则分类枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendRuleCategoryEnum
 * @Author: Zaregoto
 * @Date: 2022/3/13 20:55
 */
public enum RecommendRuleCategoryEnum {

    /**
     * 猜你想做 分类
     */
    GUESS_WHAT_YOU_WANT_TO_DO("GUESS_WHAT_YOU_WANT_TO_DO"),
    /**
    *  应用业务 入口
    */
    APP_SERVER_ENTRANCE("APP_SERVER_ENTRANCE"),
    ;

    private final String value;

    RecommendRuleCategoryEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static RecommendRuleCategoryEnum getEnumByValue(String value) {
        for (RecommendRuleCategoryEnum testedEnum : RecommendRuleCategoryEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
