package com.digiwin.mobile.mobileuibot.recommend.rule;

import java.util.Objects;

/**
 * <p>功能描述：移动推荐规则参数类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendRuleParamsTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/3/13 21:09
 */
public enum RecommendRuleParamsTypeEnum {

    /**
     * 购买商品 参数类型
     */
    PURCHASED_GOODS("PURCHASED_GOODS"),

    ;

    private final String value;

    RecommendRuleParamsTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static RecommendRuleParamsTypeEnum getEnumByValue(String value) {
        for (RecommendRuleParamsTypeEnum testedEnum : RecommendRuleParamsTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
