package com.digiwin.mobile.mobileuibot.recommend.rule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RecommendRuleServiceImpl
 * @Author: Zaregoto
 * @Date: 2022/3/13 21:31
 */
@Service("recommendRuleService")
public class RecommendRuleServiceImpl implements RecommendRuleService {

    private static final Logger logger = LoggerFactory.getLogger(RecommendRuleServiceImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<RecommendRule> findRuleByCategory(String category) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("category").is(category));

        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    @Override
    public List<RecommendRule> findRulePurchasedGoods() {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("paramsType").is(RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()));

        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    @Override
    public List<RecommendRule> findRulePurchasedGoodsByCategory(String category) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("category").is(category));
        query.addCriteria(Criteria.where("paramsType").is(RecommendRuleParamsTypeEnum.PURCHASED_GOODS.getValue()));

        return this.mongoTemplate.find(query, RecommendRule.class);
    }

    @Override
    public List<RecommendRule> findRuleByCategoryList(List<String> categoryList) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("category").in(categoryList));
        return this.mongoTemplate.find(query, RecommendRule.class);
    }
}
