package com.digiwin.mobile.mobileuibot.recommend.rule.params;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendMobileConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EnableModule
 * @Author: Zaregoto
 * @Date: 2022/3/13 21:20
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PurchasedGoodsEnableModule implements Serializable {
    private static final long serialVersionUID = -962849283387234341L;
    /**
     * 模组ID
     */
    private String moduleId;
    /**
     * 作业id
     */
    private String workId;

    //**********************默认配置******************************
    /**
     * 当前模组 -- 是否有效 true：有效；false：无效
     * 默认：false
     */
    private Boolean valid;
    /**
     * 当前模组 -- 是否需要校验查看权限 true：是；false：否
     * 默认：true
     */
    private Boolean verify;
    private RecommendMobileConfig mobileConfig;

    //**********************环境下配置******************************
    /**
     * 环境类型
     *
     * @see com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum
     */
    private String type;
    /**
     * 大陆区 环境配置
     * 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
     */
    @JsonProperty("CN")
    @JSONField(name = "CN")
    private List<PurchasedGoodsEnableModule> cn;
    /**
     * 台湾区 环境配置
     * 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
     */
    @JsonProperty("TW")
    @JSONField(name = "TW")
    private List<PurchasedGoodsEnableModule> tw;

    public void convert() {
        // 环境部署的地区
        String envDeployArea = AppContext.getEnvDeployArea();
        if (AppEnvDeployAreaEnum.CN.name().equals(envDeployArea)) {
            // 大陆
            this.convertDefaultByArea(this.cn);
        } else if (AppEnvDeployAreaEnum.TW.name().equals(envDeployArea)) {
            // 台湾
            this.convertDefaultByArea(this.tw);
        }
    }

    private void convertDefaultByArea(List<PurchasedGoodsEnableModule> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        // prod--表示生产环境；test--表示测试环境；dev-表示开发环境
        String envType = AppContext.getEnvType();
        Optional<PurchasedGoodsEnableModule> optional =
                list.stream().filter(r ->
                        StringUtils.hasLength(r.getType())
                                && r.getType().equals(envType)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        // 特定地区、特定环境下的配置值如果不为空，会替换掉默认配置中的属性值
        PurchasedGoodsEnableModule enableModule = optional.get();
        if (null != enableModule.getValid()) {
            this.valid = enableModule.getValid();
        }
        if (null != enableModule.getVerify()) {
            this.verify = enableModule.getVerify();
        }
        if (null != enableModule.getMobileConfig()) {
            if (null == this.mobileConfig) {
                this.mobileConfig = new RecommendMobileConfig();
            }
            this.mobileConfig.convert(enableModule.getMobileConfig());
        }
    }
}
