package com.digiwin.mobile.mobileuibot.scanner;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.logistics.Logistics;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;

/**
 * APP扫码后调用接口
 *
 * @author zhangjj
 * @date 2022/9/14 16:04
 */
@RestController
@RequestMapping("/mobile/v1/qrcode")
public class QrCodeController {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private ZhilinkService zhilinkService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PortalService portalService;

    @Autowired QrCodeStrategyFactory qrCodeStrategyFactory;

    private static final Logger logger = LoggerFactory.getLogger(QrCodeController.class);

    /**
     * app首页扫码
     *
     * @param request
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/scan")
    public ApiResponse scanQrCode(HttpServletRequest request) throws IOException {
        Map<String, Object> resultMap = new HashMap();
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = (String) params.get("tenantId");
        String locale = (String) params.get("locale");
        String userId = (String) params.get("userId");
        String clientId = MapUtils.getString(params, "clientId");
        Map<String, Object> buttonRawData = (Map<String, Object>) params.get("rawData");
        String bizType;
        Map<String, String> map = new HashMap<>(8);

        QrCodeDoIt qrCodeDoIt = null;

        ApiRequest apiRequest = ApiRequest.builder()
                .iamUserToken(iamUserToken)
                .tenantId(tenantId)
                .userId(userId)
                .locale(locale)
                .clientId(clientId)
                .build();

        //判断传入的content中是否包含字段t
        if(isQrCodeSearchTaskCondition(params)) {
            //提取content
            Map<String, Object> conditon = JsonUtil.jsonStringToObject(MapUtils.getString(params, "content"), Map.class);
            if (conditon.containsKey("t") && !ObjectUtil.isEmpty(conditon.get("t"))) {

                switch (conditon.get("t").toString()) {
                    // t为101，走预览门户策略
                    case "101":
                        qrCodeDoIt = this.qrCodeStrategyFactory.get(QrCodeStrategyEnum.QR_CODE_PREVIEW_PORTAL.getValue());
                        break;
                    // t为其他的，扫码搜索-跳转任务卡或者任务清单action
                    default:
                        qrCodeDoIt = this.qrCodeStrategyFactory.get(QrCodeStrategyEnum.QR_CODE_SEARCH_TASK.getValue());
                }
                //走不同策略获取Action
                Action action = qrCodeDoIt.doIt(apiRequest, conditon);
                resultMap.put("action", action);
                return ApiResponse.buildOK().setData(resultMap);
            }
        }

        String url = (String) params.get("content");
        if (!StringUtils.hasLength(url) || !url.startsWith("http")) {
            bizType = (String) buttonRawData.get("bizType");
        } else {
            map = UrlUtil.parseUrl(url);
            map = decrypt(map, sysEnvConfig.getAesKey());
            bizType = map.get("bizType");
        }

        if (QrCodeContentMsg.BIZ_TYPE_ZHILINK_ITM.equals(bizType)) {
            // 校验timestamp，超过10分钟则失效,提示二维码已失效
            String timestampStr = map.get("timestamp");
            boolean valid = true;
            if (StringUtils.hasLength(timestampStr)) {
                valid = checkTimeStamp(timestampStr);
            }
            if (!valid) {
                Action action = invalidAction(locale);
                resultMap.put("action", action);
                return ApiResponse.buildOK().setData(resultMap);
            }
            String taskNo = map.get("task_no");
            String transportNo = map.get("transport_no");
            //调用在途宝接口，加入租户，授权应用
            Map<String, Object> joinTenant = zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!(Boolean) joinTenant.get("isSuccess")) {
                resultMap.put("action", joinTenant.get("action"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            // 跳转租户先去掉，司机在个人租户和采方租户下都有在途宝权限，都能看到在途宝的任务卡（应用-毛衡）
//            String jumpTenantId = (String) digiwinEspStdData.getParameter().get("tenant_id");
//            if (StringUtils.hasLength(jumpTenantId)) {
//                resultMap.put("jumpTenantId", jumpTenantId);
//            }
            Action action = new Action();

            if (!StringUtils.hasLength(taskNo)) {
                return ApiResponse.buildOK().setData(resultMap);
            }
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            Map<String, Object> rawData = new HashMap<>(2);
            rawData.put("task_no", taskNo);
            if (StringUtils.hasLength(transportNo)) {
                rawData.put("transport_no", transportNo);
            }
            action.setRawData(rawData);
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SCAN_RECEIVE_ORDER.toString());
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
            //扫描司机码，产生运单号
        } else if (QrCodeContentMsg.BIZ_TYPE_DRIVER_CODE.equalsIgnoreCase(bizType)) {
            String taskNo = (String) buttonRawData.get("task_no");
            //调用在途宝接口，加入租户，授权应用
            Map<String, Object> joinTenant = zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!(Boolean) joinTenant.get("isSuccess")) {
                resultMap.put("action", joinTenant.get("action"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            String vehicleInfoId = map.get("vehicle_info_id");
            Map<String, Object> vehicleParams = new HashMap<>(1);
            vehicleParams.put("vehicle_info_id", vehicleInfoId);
            List<Map<String, Object>> driverVehicles = digiwinEspProxyService.getDriverVehicleDetail(iamUserToken, tenantId, locale, vehicleParams);
            Map<String, Object> rawData = new HashMap<>(4);
            rawData.put("task_no", taskNo);
            if (!CollectionUtils.isEmpty(driverVehicles)) {
                rawData.putAll(driverVehicles.get(0));
            } else {
                resultMap.put("errorMessage", localeService.getLanguageValue(locale, "车辆未找到，请重新扫描司机二维码"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            if ((Boolean) params.get("isChangeDriver")) {
                resultMap.put("errorMessage", localeService.getLanguageValue(locale, driverVehicles.get(0).get("license_plate_no") + "扫码成功/n请确认是否需要更换车辆？"));
                Action action = new Action();
                Map<String, Object> actionRawData = new HashMap<>(8);
                actionRawData.putAll(buttonRawData);
                actionRawData.put("cargo_information", params.get("cargo_information"));
                action.setRawData(actionRawData);
                resultMap.put("action", action);
                return ApiResponse.buildOK().setData(resultMap);
            }

            if (StringUtils.hasLength((String) buttonRawData.get("transport_no"))) {
                Map<String, Object> vehicleMap = new HashMap<>(5);
                vehicleMap.put("license_plate_no", driverVehicles.get(0).get("license_plate_no"));
                vehicleMap.put("vehicle_type", driverVehicles.get(0).get("vehicle_type"));
                vehicleMap.put("vehicle_length", driverVehicles.get(0).get("vehicle_length"));
                vehicleMap.put("task_no", taskNo);
                vehicleMap.put("transport_no", buttonRawData.get("transport_no"));
                //运输在途-转运
                if (PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString().
                        equalsIgnoreCase((String) buttonRawData.get("page_id"))) {
                    Action action = new Action();
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, (String) buttonRawData.get("jumpPageTitle")));
                    action.setJumpPageId((String) buttonRawData.get("page_id"));
                    buttonRawData.put("transport_no", buttonRawData.get("transport_no"));
                    buttonRawData.put("vehicle_info", driverVehicles.get(0));
                    action.setRawData(buttonRawData);
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    resultMap.put("action", action);
                    return ApiResponse.buildOK().setData(resultMap);
                } else {
                    Map<String, Object> changeVehicleMap = digiwinEspProxyService.changeTaskTransportVehicle(iamUserToken, tenantId, locale, vehicleMap);
                    if (ObjectUtil.isNotEmpty(changeVehicleMap) && ObjectUtil.isNotEmpty(changeVehicleMap.get("transport_info"))) {
                        Map<String, Object> transport_info = (Map<String, Object>) changeVehicleMap.get("transport_info");
                        buttonRawData.put("transport_no", StrUtil.toString(transport_info.get("transport_no")));
                    }
                }
            }

            Map<String, Object> codeScan = digiwinEspProxyService.taskTransportVehicleCodeScan(iamUserToken,
                    tenantId, locale, rawData);
            if (!CollectionUtils.isEmpty(codeScan)) {
                List<ActionSubmitParam> submitParams = ModuleUtils.listMapToListObject((List<?>) params.get("submitParams"), ActionSubmitParam.class);
                for (ActionSubmitParam submitParam : submitParams) {
                    switch (submitParam.getType()) {
                        case Logistics.COMPONENT_TYPE:
                            List<LogisticsData> logisticsDataList = ModuleUtils.listMapToListObject((List<?>) submitParam.getParams(), LogisticsData.class);

                            for (LogisticsData data : logisticsDataList) {
                                if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                                    codeScan.put("delivery_address_id", data.getId());
                                } else if (LogisticsEnum.RECEIVER.getValue().equals(data.getType())) {
                                    codeScan.put("receipt_address_id", data.getId());
                                }
                            }
                            break;
                        case InputDateTimePicker.COMPONENT_TYPE:
                            InputDateTimePicker inputDateTimePicker = JsonUtil.objectToJavaObject(submitParam.getParams(), InputDateTimePicker.class);
                            codeScan.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType(
                                    inputDateTimePicker.getDatetimeValue(),
                                    InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                            break;
                        default:
                            break;
                    }
                }
                return ApiResponse.buildOK().setData(zhilinkService.buildDriverCodeResultMap(resultMap, buttonRawData, codeScan, driverVehicles.get(0), params.get("cargo_information")));
            } else {
                resultMap.put("hasPrompt", true);
                resultMap.put("errorMessage", localeService.getLanguageValue(locale, "扫描失败，请重试"));
                return ApiResponse.buildOK().setData(resultMap);
            }

            //扫描货物码，进行装货
        } else if (QrCodeContentMsg.BIZ_TYPE_BAR_CODE.equalsIgnoreCase(bizType)) {
            String barcodeNo = (String) params.get("content");
            String taskNo = (String) buttonRawData.get("task_no");
            String transportNo = (String) buttonRawData.get("transport_no");
            Map<String, Object> rawData = new HashMap<>(3);
            rawData.put("task_no", taskNo);
            rawData.put("barcode_no", barcodeNo);
            rawData.put("transport_no", transportNo);
            List<ZtbCargoUnloading> cargoUnloadings = digiwinEspProxyService.taskTransportBarcodeScan(iamUserToken,
                    tenantId, locale, rawData);
            if (CollectionUtils.isEmpty(cargoUnloadings)) {
                resultMap.put("errorMessage", localeService.getLanguageValue(locale, "扫描失败，请重试"));
                return ApiResponse.buildOK().setData(resultMap);
            } else {
                List<ZtbCargoUnloading> cargoInfomations = ModuleUtils.listMapToListObject((List<?>) buttonRawData.get("cargo_infomation"), ZtbCargoUnloading.class);
                List<Card> cards = new ArrayList<>(cargoUnloadings.size());
                for (ZtbCargoUnloading cargoUnloading : cargoUnloadings) {
                    Card card = new Card();
                    StringBuffer title = new StringBuffer();
                    if (StringUtils.hasLength(cargoUnloading.getItemNo())) {
                        title.append(cargoUnloading.getItemNo()).append("-");
                    }
                    if (StringUtils.hasLength(cargoUnloading.getItemName())) {
                        title.append(cargoUnloading.getItemName());
                    } else {
                        title.append("-");
                    }
                    card.setTitle(title.toString());
                    card.setDetail(JsonUtil.objectToJavaObject(cargoUnloading, Map.class));
                    card.setDataId(cargoUnloading.getItemNo());
                    String unloadingQty = "";
                    HashMap<String, Object> rawData1 = new HashMap<>();
                    rawData1.put("item_no", cargoUnloading.getItemNo());
                    rawData1.put("item_name", cargoUnloading.getItemName());
                    rawData1.put("can_edit_qty", false);
                    for (ZtbCargoUnloading cargoInfomation : cargoInfomations) {
                        if (cargoInfomation.getItemNo().trim().equalsIgnoreCase(cargoUnloading.getItemNo())) {
                            card.getContent().add(new CardContent(localeService.getLanguageValue(locale,
                                    "应发数量"), cargoInfomation.getUnLoadingQty() + "    " + cargoInfomation.getUnitNo(), 1, "un_loading_qty"));
                            String item_qty = NumberUtil.add(cargoUnloading.getItemQty(), cargoInfomation.getItemQty()).toString();
//                            if (NumberUtil.parseNumber(item_qty).doubleValue() > NumberUtil.parseNumber(cargoInfomation.getUnLoadingQty()).doubleValue()) {
//                                return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "本次扫码数量:"+ cargoUnloading.getItemQty() +",总数量:" + item_qty + "将超过应发数量"));
//                            }
                            card.getContent().add(new CardContent(localeService.getLanguageValue(locale,
                                    "装车数量"), item_qty, 1, "item_qty"));
                            cargoInfomation.setItemQty(item_qty);
//                            card.getContent().add(new CardContent(localeService.getLanguageValue(locale,
//                                    "单位"), cargoInfomation.getUnitNo(), 1, "unit_no"));
                            String barcode_num = NumberUtil.add((StrUtil.isBlank(cargoInfomation.getBarcode_num()) ? "0" : cargoInfomation.getBarcode_num()), "1").toString();
                            cargoInfomation.setBarcode_num(barcode_num);
                            card.getContent().add(new CardContent(localeService.getLanguageValue(locale,
                                    "标签数量"), barcode_num, 1, "barcode_num"));
                            unloadingQty = cargoInfomation.getUnLoadingQty();
                            card.getDetail().put("item_unit_no", cargoInfomation.getUnitNo());
                            card.getDetail().put("item_unit_name", cargoInfomation.getUnitName());
                            rawData1.put("un_loading_qty", cargoInfomation.getUnLoadingQty());
                            rawData1.put("barcode_num", barcode_num);
                            rawData1.put("item_qty", item_qty);
                            rawData1.put("unit_no", cargoInfomation.getUnitNo());
                            rawData1.put("unit_name", cargoInfomation.getUnitName());
                            break;
                        }
                    }
                    buttonRawData.put("cargo_infomation", cargoInfomations);
                    card.setRawData(rawData1);
//                    card.setAdderSubstracter(AdderSubstracter.create(locale, localeService, unloadingQty, cargoUnloading.getItemQty(), 0.0, true, true));
                    card.setAdderSubstracter(null);
                    card.setCanEdit(true);
                    cards.add(card);
                }
                resultMap.put(Card.COMPONENT_TYPE, cards);
                Map<String, Object> result = new HashMap<>(2);
                result.put("type", 2);
                resultMap.put("result", result);
                Action action = new Action();
                action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/car/loading/submit");
                action.setRawData(buttonRawData);
                resultMap.put("action", action);

                return ApiResponse.buildOK().setData(resultMap);
            }
            //扫ASN单子
        } else if (QrCodeContentMsg.BIZ_TYPE_ASN_CODE.equalsIgnoreCase(bizType)) {
            Action action = JsonUtil.objectToJavaObject(buttonRawData.get("action"), Action.class);
            String sourceNo = (String) params.get("content");
            Map<String, Object> sourceDetail = digiwinEspProxyService.getDeliverySourceDetail(iamUserToken, tenantId, locale, sourceNo);
            sourceDetail.put("source_no", sourceNo);
            action.setRawData(sourceDetail);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
            //扫货运单
        } else if (QrCodeContentMsg.BIZ_TYPE_TRANSPORT_RECEIVE.equalsIgnoreCase(bizType)) {
            Action action = new Action();
            String transportNo = map.get("transport_no");
            //调敏态接口接单
            Map<String, Object> stringObjectMap = digiwinEspProxyService.scanTransportToReceive(userId, iamUserToken, tenantId, locale, transportNo);
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(localeService.getLanguageValue(locale, StrUtil.toString(stringObjectMap.get("message"))));
            Map<String, Object> map1 = new HashMap<>();
            map1.put("action", action);
            resultMap.put("data", map1);
            return ApiResponse.buildOK().setData(resultMap);
        } else if (url.startsWith("http")) {
            // 跳转webView
            Action action = webViewAction(url);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        } else {
            resultMap.put("hasPrompt", true);
            resultMap.put("hasCancel", false);
            resultMap.put("errorMessage", localeService.getLanguageValue(locale, "扫描失败，请重试"));
            return ApiResponse.buildOK().setData(resultMap);
        }
    }

    private boolean isQrCodePrePortalCondition(Map<String, Object> params) {
        if (Objects.nonNull(params.get("content"))) {
            try {
                Map<String, Object> conditon = JsonUtil.jsonStringToObject(MapUtils.getString(params, "content"), Map.class);
                return conditon.containsKey("t") && conditon.get("t").equals("101");
            } catch (Exception e) {
                logger.error("isQrCodePrePortalCondition qrCode is : {}", params.get("content"));
            }
        }
        return false;
    }

    // 判断是否是助兴或者天岛的扫码数据
    private boolean isQrCodeSearchTaskCondition(Map<String, Object> params) {
        if (Objects.nonNull(params.get("content"))) {
            try {
                Map<String, Object> conditon = JsonUtil.jsonStringToObject(MapUtils.getString(params, "content"), Map.class);
                return conditon.containsKey("t");
            } catch (Exception e) {
                logger.error("isQrCodeSearchTaskCondition qrCode is : {}", params.get("content"));
            }
        }
        return false;
    }

    public static boolean isArray(String str) {
        try {
            new JSONArray(str);
            return true;
        } catch (JSONException e) {
            return false;
        }
    }

    /**
     * 跳转webView的action
     *
     * @param url
     * @return
     */
    private Action webViewAction(String url) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        action.setRequestUrl(url);
        return action;
    }

    /**
     * 失效按钮
     *
     * @return
     */
    private Action invalidAction(String locale) {
        Action action = new Action<>();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey(locale, "提示"));
        popPromptMsg.setContent(LocaleUtil.getMobileTextByKey(locale, "二维码失效"));
        Button button = new Button();
        button.setName(LocaleUtil.getMobileTextByKey(locale, "确定"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        List<Button> buttonList = new ArrayList<>();
        buttonList.add(button);
        popPromptMsg.setButtonList(buttonList);
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }

    /**
     * 校验时间戳
     *
     * @param timestampStr
     * @return 有效则返回true，失效返回false
     */
    private boolean checkTimeStamp(String timestampStr) {
        if (!StringUtils.hasLength(timestampStr)) {
            return false;
        }
        long timestamp = Long.parseLong(timestampStr);
        long currentTime = System.currentTimeMillis();
        if (currentTime - timestamp > 10 * 60 * 1000) {
            //超过10分钟，失效
            return false;
        }
        return true;
    }

    /**
     * map中value值解密
     *
     * @param map
     * @param aesKey
     * @return
     */
    private Map<String, String> decrypt(Map<String, String> map, String aesKey) {
        Set<String> keys = map.keySet();
        keys.stream().forEach(key -> {
            String value = map.get(key);
            try {
                value = AESUtil.decrypt(aesKey, value);
            } catch (Exception e) {
                e.printStackTrace();
            }
            map.put(key, value);
        });
        return map;
    }

}
