package com.digiwin.mobile.mobileuibot.search;

import java.util.Objects;

/**
 * <p>功能描述：搜索类别枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SearchCategoryEnum
 * @Author: Zaregoto
 * @Date: 2022/6/1 17:52
 */
public enum SearchCategoryEnum {

    /**
     * 包含Athena和知识中台的全部搜索
     */
    ALL("all"),
    /**
     * athena--项目搜索
     */
    ATHENA_PROJECT("athena_project"),
    /**
     * athena--任务搜索
     */
    ATHENA_TASK("athena_task"),
    /**
     * athena--全部搜索
     */
    ATHENA_ALL("athena_all"),
    /**
     * 知识中台——问题搜索（前端使用）
     */
    KBS_QUESTION("kbs_question"),
    /**
     * 知识中台——全部搜索
     */
    KBS_ALL("kbs_all"),
    /**
     * 知识中台——问题搜索（后端调用接口使用）
     */
    QUESTION("question"),
    /**
     * 报表名称搜索
     */
    REPORT_NAME("report_name"),
    /**
    * 主管查看人员状况 搜索
    */
    PERSONNEL_ONLINE_SEARCH("personnel_online_search"),
    ;

    private final String value;

    SearchCategoryEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static SearchCategoryEnum getEnumByValue(String value) {
        for (SearchCategoryEnum testedEnum : SearchCategoryEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
