package com.digiwin.mobile.mobileuibot.search;

import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.search.*;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelOnlineManage;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.StateTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcSearchTaskResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.kbs.model.Pagination;
import com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.DigiwinKbsService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchContent;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchContentData;
import com.digiwin.mobile.mobileuibot.search.model.GlobalSearchData;
import com.digiwin.mobile.mobileuibot.search.service.MobileSearchService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.pattern.bean.PatternDetail.PATTERN_TYPE_PROJECT;

/**
 * 移动的搜索组件
 *
 * @author wuyang
 */
@RestController
@RequestMapping("/mobile/v1/search")
public class SearchController {

    /**
     * 搜索组件类型-模糊搜索
     */
    private static final int SEARCH_TYPE_FUZZY = 0;
    /**
     * 搜索组件类型-精准搜索
     */
    private static final int SEARCH_TYPE_PRECISE = 1;
    /**
     * 搜索组件类型-精准搜索 直接搜索
     */
    private static final int SEARCH_TYPE_DIRECT_PRECISE = 2;
    /**
     * 聚合搜索中的项目搜索
     */
    private static final String GLOBAL_SEARCH_TYPE_PROJECT = "0";
    /**
     * 聚合搜索中的任务搜索
     */
    private static final String GLOBAL_SEARCH_TYPE_TASK = "1";
    /**
     * 是否显示更多的笔数，超过则显示
     */
    private static final int SHOW_MORE_SIZE = 3;

    @Autowired
    private MobileSearchService mobileSearchService;
    @Autowired
    private DigiwinKbsService digiwinKbsService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private CustomTaskConfigService customTaskConfigService;

    @Autowired
    private ProjectFilterService projectFilterService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    /**
     * 搜索接口
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/allSearch", method = RequestMethod.POST)
    public ApiResponse allSearch(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        Integer searchType = (Integer) params.get("searchType");
        String tenantId = (String) params.get("tenantId");
        String question = (String) params.get("question");
        String iamUserToken = (String) params.get("iamUserToken");
        String locale = (String) params.get("locale");
        Map<String, String> ext = (Map<String, String>) params.get("ext");
        Boolean useCountNum = (Boolean) params.get("useCountNum");
        String countText = (String) params.get("countText");
        String countTextTemplate = (String) params.get("countTextTemplate");
        String sid = (String) params.get("sid");
        String tmActivityId = (String) params.get("tmActivityId");
        String inquiryNo = (String) params.get("inquiry_no");
        List<SmartPreciseSearch> smartPreciseSearches = new ArrayList<>();
        Map<String, String> apiRequest = (Map<String, String>) params.get("apiRequest");

        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        if (useMockData || modelTypeShow) {
            Map<String, Object> mockData = this.doMockData(searchType);
            return ApiResponse.buildOK().setData(mockData);
        }

        //模糊搜索
        if (SEARCH_TYPE_FUZZY == searchType) {
            List<SmartFuzzySearch> smartFuzzySearches = mobileSearchService.findFuzzySearch(tenantId, question, ext, iamUserToken);
            if (smartFuzzySearches == null) {
                Map<String, Object> bigData = new HashMap<>(1);
                List emptyList = new ArrayList(0);
                bigData.put("contentList", emptyList);
                return ApiResponse.buildOK().setData(bigData);
            } else {
                Map<String, Object> bigData = new HashMap<>(1);
                List<Map<String, Object>> contentListData = new ArrayList<>();
                for (SmartFuzzySearch smartFuzzySearch : smartFuzzySearches) {
                    Map<String, Object> data = new HashMap<>(smartFuzzySearches.size());
                    data.put("componentType", SmartFuzzySearch.COMPONENT_TYPE + "_ITEM");
                    data.put("data", smartFuzzySearch);
                    contentListData.add(data);
                }
                bigData.put("contentList", contentListData);
                return ApiResponse.buildOK().setData(bigData);
            }
            //精准搜索
        } else if (SEARCH_TYPE_PRECISE == searchType) {
            smartPreciseSearches = mobileSearchService.findPreciseSearches(tenantId, question, sid, ext, iamUserToken, locale, apiRequest);
        } else if (SEARCH_TYPE_DIRECT_PRECISE == searchType) {
            smartPreciseSearches = mobileSearchService.findDirectPreciseSearches(tmActivityId, inquiryNo, iamUserToken, tenantId, locale, apiRequest);
        }
        if (smartPreciseSearches == null || smartPreciseSearches.size() < 1) {
            Map<String, Object> data = new HashMap<>();
            data.put("contentList", new ArrayList<>(0));
            return ApiResponse.buildOK().setData(data);
        } else {
            return ApiResponse.buildOK().setData(buildModel(smartPreciseSearches, question, countText, countTextTemplate, useCountNum, tmActivityId));
        }
    }

    public Map<String, Object> buildModel(List<SmartPreciseSearch> smartPreciseSearches, String question, String countText, String countTextTemplate, Boolean useCountNum, String tmActivityId) {
//        String countNumText = "";
//        if(useCountNum) {
//            countNumText = countText.replace(countTextTemplate, String.valueOf(smartPreciseSearches.size()));
//        }
//        SmartPreciseSearchItemList smartPreciseSearchItemList = new SmartPreciseSearchItemList(countNumText);
//        smartPreciseSearchItemList.addAllListItems(smartPreciseSearches, SmartPreciseSearch.COMPONENT_TYPE + "_ITEM");
//
//        return smartPreciseSearchItemList;
        Map<String, Object> data = new HashMap<>();
        if (useCountNum && !StringUtils.isEmpty(countTextTemplate)) {
            data.put("countNumText", countText.replace(countTextTemplate, String.valueOf(smartPreciseSearches.size())));
        } else {
            data.put("countNumText", "");
        }
        List<Map<String, Object>> contentList = new ArrayList<>(smartPreciseSearches.size());
        for (SmartPreciseSearch smartPreciseSearch : smartPreciseSearches) {
            Map<String, Object> rawData = new HashMap<>(1);
            rawData.put("searchQ", question);
            Map<String, Object> content = new HashMap<>(2);
            String componentType = SmartPreciseSearch.COMPONENT_TYPE + "_ITEM";
            Map<String, Object> dataMap = new HashMap<>(4);
            dataMap.put("fields", smartPreciseSearch.getFields());
            dataMap.put("pic", smartPreciseSearch.getPics());
            dataMap.put("styleType", smartPreciseSearch.getStyleType());
            Map<String, Object> action = new HashMap<>(4);
            action.put("dataId", "");
            if (Objects.equals(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue(), smartPreciseSearch.getStyleType())) {
                action.put("jumpPageId", PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_DETAIL);
                dataMap.put("searchType", SEARCH_TYPE_PRECISE);
                data.put("entryJump", true);
            } else if (Objects.equals(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue(), smartPreciseSearch.getStyleType())) {
                action.put("jumpPageId", PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_LIST);
                data.put("entryJump", false);
                dataMap.put("searchType", SEARCH_TYPE_DIRECT_PRECISE);
            }
            action.put("type", ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            if (smartPreciseSearch.getAction() != null) {
                Map<String, Object> row = (Map<String, Object>) smartPreciseSearch.getAction().getRawData();
                Map<String, Object> map = (Map<String, Object>) row.get("params");
                if (map.keySet().contains("params")) {
                    rawData.putAll(map);
                } else {
                    rawData.put("params", map);
                }
                if (StringUtils.hasLength((CharSequence) row.get("dataKey"))) {
                    rawData.put("dataKey", row.get("dataKey"));
                } else {
                    rawData.put("dataKey", smartPreciseSearch.getFields().get(0).getFieldValue());
                }
                String tmActivityId1 = (String) row.get("tmActivityId");
                if (StringUtils.hasLength(tmActivityId1)) {
                    tmActivityId = tmActivityId1;
                }
                rawData.put("tmActivityId", tmActivityId);
                //包含ddc_inquiry则代表为询价单，全部不显示搜索框
                if (tmActivityId.contains("ddc_inquiry")) {
                    data.put("showSearchBox", false);
                } else {
                    data.put("showSearchBox", true);
                }
            } else {
                rawData.put("dataKey", smartPreciseSearch.getFields().get(0).getFieldValue());
            }
            action.put("rawData", rawData);
            dataMap.put("action", action);
            content.put("componentType", componentType);
            content.put("data", dataMap);
            contentList.add(content);
        }
        data.put("contentList", contentList);
        return data;
    }


    private Map<String, Object> doMockData(int searchType) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        Map<String, Object> mockSearchData = null;
        if (SEARCH_TYPE_FUZZY == searchType) {
            data = FileUtil.readText("static/smartsearch-fuzzysearch-result.json");
        } else if (SEARCH_TYPE_PRECISE == searchType) {
            data = FileUtil.readText("static/smartsearch-precisesearch-result.json");
        } else if (SEARCH_TYPE_DIRECT_PRECISE == searchType) {
//            data = FileUtil.readText("static/smartsearch-directprecisesearch-result.json");
            data = FileUtil.readText("static/smartsearch-precisesearch-result.json");
        } else {
            data = "";
        }
        if (null != data && !data.isEmpty()) {
            mockSearchData = JsonUtil.jsonStringToObject(data, Map.class);
        }

        return mockSearchData;
    }

    /**
     * 聚合搜索--目前只对接了知识中台
     * 新增对接Athena平台的搜索
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/globalSearch", method = RequestMethod.POST)
    public ApiResponse<Map<String, Object>> globalSearch(HttpServletRequest request) throws IOException {
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) params.get("locale");
        String tenantId = (String) params.get("tenantId");
        String searchContent = (String) params.get("searchContent");
        String iamUserToken = (String) params.get("iamUserToken");
        String userId = (String) params.get("userId");
        String searchCategoryId = (String) params.get("searchCategoryId");
        Map<String, Object> rawData = (Map<String, Object>) params.get("rawData");
        if (!CollectionUtils.isEmpty(rawData)) {
            searchCategoryId = (String) rawData.get("searchCategoryId");
        }

        //目前默认为查全部
        if (searchCategoryId == null) {
            searchCategoryId = SearchCategoryEnum.ALL.getValue();
        }
        Integer page = (Integer) params.get("page");
        Integer pageSize = (Integer) params.get("pageSize");
        Map<String, Object> knowledgeInfos = new HashMap<>(9);
        Map<String, Object> pagination = new HashMap<>(2);
        pagination.put("page", page);
        pagination.put("page_size", pageSize);
        knowledgeInfos.put("pagination", pagination);
        knowledgeInfos.put("knowledge_classification_no", "");
        knowledgeInfos.put("search_content", searchContent);
        knowledgeInfos.put("knowledge_classification_name", "");
        knowledgeInfos.put("tag_classification_no", "");
        knowledgeInfos.put("tag_classification_name", "");
        knowledgeInfos.put("start_time", "");
        knowledgeInfos.put("end_time", "");

        Map<String, Object> data = new HashMap<>();
        List<GlobalSearchData> searchData = new ArrayList<>(4);
        if (modelTypeShow) {
            return ApiResponse.buildOK().setData(this.doMockData(locale));
        } else {
            switch (SearchCategoryEnum.getEnumByValue(searchCategoryId)) {
                case ALL:
                    searchData.addAll(buildGlobalSearchModel(knowledgeInfos, iamUserToken,
                            locale, tenantId, searchCategoryId, searchContent));
                    break;
                case ATHENA_ALL:
                    searchData.addAll(buildAthenaGlobalSearchModel(digiwinAtmcProxyService.getSearchResult(
                            iamUserToken, locale, searchContent, tenantId), locale, searchCategoryId, searchContent, tenantId, iamUserToken));
                    break;
                case ATHENA_TASK:
//                    searchData.add(buildAthenaTaskGlobalSearchModel(digiwinAtmcProxyService.getSearchTaskResult(
//                            iamUserToken, locale, searchContent, tenantId), locale, LocaleUtil.getMobileTextByKey(locale, "任务"), searchContent, GLOBAL_SEARCH_TYPE_TASK, searchCategoryId));
                    searchData.add(buildAthenaProjectOrTaskGlobalSearchModel(digiwinAtmcProxyService.getSearchResult(
                            iamUserToken, locale, searchContent, tenantId), locale, LocaleUtil.getMobileTextByKey(locale, "任务"), searchContent, GLOBAL_SEARCH_TYPE_TASK, searchCategoryId, tenantId, iamUserToken));
                    break;
                case ATHENA_PROJECT:
                    searchData.add(buildAthenaProjectOrTaskGlobalSearchModel(digiwinAtmcProxyService.getSearchResult(
                            iamUserToken, locale, searchContent, tenantId), locale, LocaleUtil.getMobileTextByKey(locale, "项目"), searchContent, GLOBAL_SEARCH_TYPE_PROJECT, searchCategoryId, tenantId, iamUserToken));
                    break;
                case KBS_QUESTION:
                    searchCategoryId = searchCategoryId.split("kbs_")[1];
                    knowledgeInfos.put("search_range", searchCategoryId);
                    searchData.add(buildKbsGlobalSearchModel(
                            digiwinKbsService.getInfoBaseHome(knowledgeInfos, iamUserToken, locale)
                            , locale, searchCategoryId, SearchCategoryEnum.KBS_QUESTION.getValue(), searchContent));
                    break;
                case REPORT_NAME:
                    searchData.add(buildReportName(audcProxyService.getTmDataList("",
                            iamUserToken, tenantId, locale), locale, localeService.getLanguageValue(locale, "报表"), searchContent, searchCategoryId));
                    break;
                case PERSONNEL_ONLINE_SEARCH:
                    String eocCompanyId = "";
                    String eocSiteId = "";
                    if (!CollectionUtils.isEmpty(rawData) && null != rawData.get("eoc_company_id")) {
                        // 判断rawData中是否存在数据
                        List<InputCascade.DefaultSelect> defaultSelects = JsonUtil.objectToJavaObject(rawData.get("eoc_company_id"),
                                new TypeReference<List<InputCascade.DefaultSelect>>() {
                                });
                        if (!CollectionUtils.isEmpty(defaultSelects)) {
                            eocCompanyId = defaultSelects.get(0).getId();
                            eocSiteId = defaultSelects.get(1).getId();
                        }
                    }
                    searchData.add(buildPersonnelOnlineSearch(
                            personnelOnlineManage.woOpReportPersonnelGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId),
                            SearchCategoryEnum.PERSONNEL_ONLINE_SEARCH.getValue(), searchContent, locale, iamUserToken, tenantId));
                    break;
                default:
                    break;
            }
            data.put("data", searchData);
            return ApiResponse.buildOK().setData(data);
        }
    }

    private GlobalSearchData buildPersonnelOnlineSearch(
            List<WoOpReportInfo> allReportList, String searchCategoryId, String searchContent, String locale, String iamUserToken, String tenantId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(localeService.getLanguageValue(locale, "人员上线情况"));
        globalSearchData.setUsePaging(true);
        globalSearchData.setEntryJump(true);
        globalSearchData.setShowSearchBox(true);
        globalSearchData.setUseExpand(false);
        //筛选出内容
        List<WoOpReportInfo> contentList = allReportList.stream()
                .filter(reportInfo -> {
                    if (!StringUtils.hasText(searchContent)) {
                        return false;
                    }
                    boolean reporterName = Optional.ofNullable(reportInfo.getReporterName()).orElse("").contains(searchContent);
                    boolean supporterName = Optional.ofNullable(reportInfo.getSupporterName()).orElse("").contains(searchContent);
                    boolean opName = Optional.ofNullable(reportInfo.getOpName()).orElse("").contains(searchContent);
                    boolean woNo = Optional.ofNullable(reportInfo.getWoNo()).orElse("").contains(searchContent);
                    boolean plotNo = Optional.ofNullable(reportInfo.getPlotNo()).orElse("").contains(searchContent);
                    boolean planLotNo = Optional.ofNullable(reportInfo.getPlanLotNo()).orElse("").contains(searchContent);
                    boolean projectName = Optional.ofNullable(reportInfo.getProjectName()).orElse("").contains(searchContent);
                    boolean areaName = Optional.ofNullable(reportInfo.getAreaName()).orElse("").contains(searchContent);
                    return reporterName || supporterName || opName || woNo || plotNo || planLotNo || projectName || areaName;
                }).collect(Collectors.toList());
        int size = contentList.size();

        // 获取已上线的合并工时数据
        List<WoOpReportInfo> onLineContentList = contentList.stream().filter(e -> PersonnelStateEnum.ONLINE.equals(e.getStateEnum()) && StringUtils.hasLength(e.getMergeNo())).collect(Collectors.toList());
        Map<String, List<WoOpReportInfo>> onLineWoOpReportInfoMapByMergeNo = onLineContentList.stream()
                .collect(Collectors.groupingBy(WoOpReportInfo::getMergeNo));

        List<GlobalSearchContent> globalSearchContentList = new ArrayList<>();
        for (Map.Entry<String, List<WoOpReportInfo>> woOpReportInfoMapByMergeNoItem : onLineWoOpReportInfoMapByMergeNo.entrySet()) {
            List<WoOpReportInfo> woOpReportInfoListByMergeNo = woOpReportInfoMapByMergeNoItem.getValue();
            // 同一个合并单号的数据需要根据人员名称再分组
            Map<String, List<WoOpReportInfo>> woOpReportInfoMapByReportName = woOpReportInfoListByMergeNo.stream().collect(Collectors.groupingBy(WoOpReportInfo::getReporterName));
            for (List<WoOpReportInfo> woOpReportInfoListByReportName : woOpReportInfoMapByReportName.values()) {
                globalSearchContentList.add(buildGlobalSearchContent(woOpReportInfoListByReportName, searchCategoryId, locale, true));
            }
        }
        contentList.removeAll(onLineContentList);

        // 第一层分组条件根据交付设计器来 1：工单单号， 2：项目号，3：计划批号
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(iamUserToken,
                tenantId, locale, Collections.singletonList("taskNameField"));
        String taskNameField = Optional.ofNullable(variableListSimpleMap).map(e-> MapUtils.getString(e, "taskNameField")).orElse("");

        List<WoOpReportInfo> supportContentList = contentList.stream().filter(e -> PersonnelStateEnum.SUPPORT.equals(e.getStateEnum())).collect(Collectors.toList());
        Map<String, Map<String, List<WoOpReportInfo>>> woOpReportInfoListByWoNoAndOpNo = supportContentList.stream()
                .collect(Collectors.groupingBy(e -> {
                    if ("2".equals(taskNameField)) {
                        return e.getProjectNo();
                    } else if ("3".equals(taskNameField)) {
                        return e.getPlanLotNo();
                    }
                    return e.getWoNo();
                }, LinkedHashMap::new, Collectors.groupingBy(WoOpReportInfo::getOpNo, LinkedHashMap::new, Collectors.toList())));
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setLocale(locale);
        List<Retractable> retractableList = Retractable.buildRetractable(apiRequest, localeService, woOpReportInfoListByWoNoAndOpNo, taskNameField, "#F8F8FC");
        List<GlobalSearchContent> supportGlobalSearchContentList = retractableList.stream().map(retractable -> {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType(Retractable.COMPONENT_TYPE);
            globalSearchContent.setContent(retractable);
            return globalSearchContent;
        }).collect(Collectors.toList());
        globalSearchContentList.addAll(supportGlobalSearchContentList);
        contentList.removeAll(supportContentList);

        List<GlobalSearchContent> globalSearchContentListNotByMergeNo = contentList.stream().map(reportInfo ->
                buildGlobalSearchContent(Collections.singletonList(reportInfo), searchCategoryId, locale, false)
        ).collect(Collectors.toList());
        globalSearchContentList.addAll(globalSearchContentListNotByMergeNo);
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), size));
        globalSearchData.setContentList(globalSearchContentList);
        return globalSearchData;
    }

    private GlobalSearchContent buildGlobalSearchContent(List<WoOpReportInfo> woOpReportInfoList, String searchCategoryId, String locale, boolean isMerge) {
        WoOpReportInfo reportInfo = woOpReportInfoList.get(0);

        GlobalSearchContent globalSearchContent = new GlobalSearchContent();
        globalSearchContent.setComponentType(GlobalSearchItemList.COMPONENT_TYPE);

        GlobalSearchContentData contentData = new GlobalSearchContentData();
        contentData.setSearchType(searchCategoryId);
        contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());

        List<SmartPreciseSearchField> fields = new ArrayList<>();
        fields.add(SmartPreciseSearchField
                .create(reportInfo.getReporterNo(), reportInfo.getReporterName(), false, 1));
        SmartPreciseSearchField stateField = SmartPreciseSearchField
                .create(null, localeService.getLanguageValue(locale, reportInfo.getStateEnum().getDesc()), false, 2);
        fields.add(stateField);
        switch (reportInfo.getStateEnum()) {
            case ONLINE:
                stateField.setFieldType(StateTypeEnum.NORMAL.getValue());

                String opNameLabel = "zh_TW".equalsIgnoreCase(locale) ? "所在製程" : "所在工艺";
                if (isMerge) {
                    fields.add(SmartPreciseSearchField
                            .create(null, opNameLabel + " " + (StringUtils.hasLength(reportInfo.getOpName()) ? reportInfo.getOpName() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, localeService.getLanguageValue(locale, "合并单号") + " " + (StringUtils.hasLength(reportInfo.getMergeNo()) ? reportInfo.getMergeNo() : "-"), false, 1));

                    Action queryAction = new Action();
                    queryAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_MERGE_DETAIL.toString());
                    queryAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    queryAction.setDataId(UUIDUtil.getUuid());
                } else {
                    // 中文显示项目代号，项目名称, 繁体显示繁体的 专案代号，专案名称
                    String projectNoLabel = "zh_TW".equalsIgnoreCase(locale) ? "專案代號" : "项目代号";
                    String projectNameLabel = "zh_TW".equalsIgnoreCase(locale) ? "專案名稱" : "项目名称";
                    String woNoLabel = "zh_TW".equalsIgnoreCase(locale) ? "製令單號" : "工单单号";
                    fields.add(SmartPreciseSearchField
                            .create(null, opNameLabel + " " + (StringUtils.hasLength(reportInfo.getOpName()) ? reportInfo.getOpName() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, woNoLabel + " " + (StringUtils.hasLength(reportInfo.getWoNo()) ? reportInfo.getWoNo() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, localeService.getLanguageValue(locale, "品名") + " " + (StringUtils.hasLength(reportInfo.getItemName()) ? reportInfo.getItemName() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, localeService.getLanguageValue(locale, "规格") + " " + (StringUtils.hasLength(reportInfo.getItemSpec()) ? reportInfo.getItemSpec() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, projectNoLabel + " " + (StringUtils.hasLength(reportInfo.getProjectNo()) ? reportInfo.getProjectNo() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, projectNameLabel + " " + (StringUtils.hasLength(reportInfo.getProjectName()) ? reportInfo.getProjectName() : "-"), false, 1));
                    fields.add(SmartPreciseSearchField
                            .create(null, localeService.getLanguageValue(locale, "区域") + " " + (StringUtils.hasLength(reportInfo.getAreaName()) ? reportInfo.getAreaName() : "-"), false, 1));
                }
                List<Button> buttonList = Button.buildButtonList(woOpReportInfoList, locale,  localeService, isMerge);
                contentData.setButtonList(buttonList);
                break;
            case OFFLINE:
                stateField.setFieldType(StateTypeEnum.ABNORMAL.getValue());
                break;
            case EXCEPT:
                stateField.setFieldType(StateTypeEnum.GENERAL.getValue());
                fields.add(SmartPreciseSearchField
                        .create(null, localeService.getLanguageValue(locale, "除外原因") + " " + (StringUtils.hasLength(reportInfo.getExceptName()) ? reportInfo.getExceptName() : "-"), false, 1));
                fields.add(SmartPreciseSearchField
                        .create(null, localeService.getLanguageValue(locale, "时间") + " " + this.exceptTime(reportInfo.getStartTime(), reportInfo.getEndTime()), false, 1));
                break;
            default:
                break;
        }
        fields.add(SmartPreciseSearchField
                .create(null, localeService.getLanguageValue(locale, "组别") + " " + (StringUtils.hasLength(reportInfo.getTeamName()) ? reportInfo.getTeamName() : "-"), false, 1));
        contentData.setFields(fields);
        globalSearchContent.setData(contentData);
        return globalSearchContent;
    }

    private String exceptTime(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(startTime).split(" ")[1].substring(0, 5) +
                "-" +
                sdf.format(endTime).split(" ")[1].substring(0, 5);
    }

    /**
     * 搜索报表名称
     *
     * @param tmDataList
     * @param locale
     * @param name
     * @param searchContent
     * @param searchCategoryId
     * @return
     */
    private GlobalSearchData buildReportName(List<DigiwinAtmcTmData> tmDataList, String locale, String name, String searchContent, String searchCategoryId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(true);
        globalSearchData.setEntryJump(true);
        globalSearchData.setShowSearchBox(true);
        globalSearchData.setUseExpand(false);
        List<GlobalSearchContent> contentList = new ArrayList<>();
        //筛选出内容
        for (DigiwinAtmcTmData tmData : tmDataList) {
            List<DigiwinAtmcTmDataReport> baseItemDtoList = tmData.getBaseItemDtoList();
            for (DigiwinAtmcTmDataReport dataReport : baseItemDtoList) {
                if (dataReport.getName().contains(searchContent) && dataReport.isAllow()) {
                    GlobalSearchContent globalSearchContent = new GlobalSearchContent();
                    globalSearchContent.setComponentType(GlobalSearchItemList.COMPONENT_TYPE);
                    GlobalSearchContentData contentData = new GlobalSearchContentData();
                    contentData.setIconData(59124);
                    contentData.setSearchType(searchCategoryId);
                    contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
                    Action action = new Action();
                    action.setDataId(dataReport.getCode());
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    action.setJumpPageTitle(dataReport.getName());
                    //此处不改，后续搜索这块PO有新的规划
                    if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_DETAIL.toString());
                    } else {
                        continue;
                    }

                    Map<String, Object> rawData = new HashMap<>(1);
                    rawData.put("data", dataReport);
                    action.setRawData(rawData);
                    contentData.setAction(action);

                    List<SmartPreciseSearchField> fields = new ArrayList<>(2);
                    //报表名称
                    SmartPreciseSearchField searchTaskNameField = new SmartPreciseSearchField();
                    searchTaskNameField.setFieldId(String.valueOf(dataReport.getItemId()));
                    searchTaskNameField.setFieldValue(dataReport.getName());
                    searchTaskNameField.setSkip(false);
                    searchTaskNameField.setFieldLayoutType(1);
                    fields.add(searchTaskNameField);
                    //任务所属项目
                    SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                    searchField.setFieldId(String.valueOf(dataReport.getAppCode()));
                    searchField.setFieldValue(localeService.getLanguageValue(locale, "所属应用：") + tmData.getAppName());
                    searchField.setSkip(false);
                    searchField.setFieldLayoutType(1);
                    fields.add(searchField);

                    contentData.setFields(fields);
                    globalSearchContent.setData(contentData);
                    contentList.add(globalSearchContent);
                }
            }
        }
        int size = contentList.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), size));
        globalSearchData.setContentList(contentList);
        return globalSearchData;
    }

    private GlobalSearchData buildAthenaTaskGlobalSearchModel(List<DigiwinAtmcSearchTaskResult> searchTaskResult, String locale, String name, String searchContent, String globalSearchType, String searchCategoryId) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(true);
        globalSearchData.setEntryJump(true);
        globalSearchData.setShowSearchBox(true);
        globalSearchData.setUseExpand(false);
        int size = searchTaskResult.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), size));
        globalSearchData.setContentList(buildAthenaTaskGlobalSearchData(searchTaskResult, searchCategoryId.split("athena_")[1], locale));
        return globalSearchData;
    }

    /**
     * athena搜索的任务卡或者项目卡条目
     *
     * @param searchResult
     * @param locale
     * @param name
     * @param searchContent
     * @param globalSearchType
     * @param searchCategoryId
     * @param tenantId
     * @param iamUserToken
     * @return
     */
    private GlobalSearchData buildAthenaProjectOrTaskGlobalSearchModel(List<DigiwinAtmcSearchResult> searchResult,
                                                                       String locale, String name,
                                                                       String searchContent,
                                                                       String globalSearchType,
                                                                       String searchCategoryId,
                                                                       String tenantId, String iamUserToken) {
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(searchCategoryId);
        globalSearchData.setName(name);
        globalSearchData.setUsePaging(true);
        globalSearchData.setEntryJump(true);
        globalSearchData.setShowSearchBox(true);
        globalSearchData.setUseExpand(false);
        searchResult = searchResult.stream().filter(result -> globalSearchType.equals(result.getType())).collect(Collectors.toList());
        int size = searchResult.size();
        globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), size));
        globalSearchData.setContentList(buildAthenaProjectOrTaskGlobalSearchData(searchResult,
                searchCategoryId.split("athena_")[1], searchContent, locale, globalSearchType,
                tenantId, iamUserToken));
        return globalSearchData;
    }

    /**
     * athena搜索的任务卡(新接口)
     *
     * @param searchResult
     * @param searchCategoryId
     * @param locale
     * @return
     */
    private List<GlobalSearchContent> buildAthenaTaskGlobalSearchData(List<DigiwinAtmcSearchTaskResult> searchResult, String searchCategoryId, String locale) {
        List<GlobalSearchContent> contentList = new ArrayList<>(searchResult.size());
        for (DigiwinAtmcSearchTaskResult result : searchResult) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType(GlobalSearchItemList.COMPONENT_TYPE);
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            //任务前面加上图标
            contentData.setIconData(58937);
            contentData.setSearchType(searchCategoryId);
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            Action action = new Action();
            action.setDataId(String.valueOf(result.getTaskId()));
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            action.setRequestUrl("/mobile/v1/pattern/jump/info?type=search");
            DigiwinAtmcSearchResult atmcSearchResult = new DigiwinAtmcSearchResult();
            atmcSearchResult.setEndTime(result.getProjectEndTime());
            atmcSearchResult.setId(result.getTaskId());
            atmcSearchResult.setName(result.getTaskName());
            atmcSearchResult.setStartTime(result.getProjectStartTime());
            atmcSearchResult.setType(PATTERN_TYPE_PROJECT);
            atmcSearchResult.setCode(String.valueOf(result.getTaskId()));
            atmcSearchResult.setEngineType("TaskEngine");
            action.setRawData(atmcSearchResult);
            contentData.setAction(action);

            List<SmartPreciseSearchField> fields = new ArrayList<>(1);
            //任务名称
            SmartPreciseSearchField searchTaskNameField = new SmartPreciseSearchField();
            searchTaskNameField.setFieldId(String.valueOf(result.getTaskId()));
            //为任务时，截取结束时间+任务名称
            searchTaskNameField.setFieldValue(DateTimeUtil.getMonthDateOfTime(result.getPlanEndTime())
                    + LocaleUtil.getMobileTextByKey(locale, "需完成") + " " + result.getTaskName());
            searchTaskNameField.setSkip(false);
            searchTaskNameField.setFieldLayoutType(1);
            fields.add(searchTaskNameField);
            //任务所属项目
            SmartPreciseSearchField searchField = new SmartPreciseSearchField();
            searchField.setFieldId(String.valueOf(result.getTaskId()));
            searchField.setFieldValue(localeService.getLanguageValue(locale, "项目：") + DateTimeUtil.getMonthDateOfTime(result.getProjectStartTime()) + "~"
                    + DateTimeUtil.getMonthDateOfTime(result.getProjectEndTime()) + " " + result.getProjectName());
            searchField.setSkip(false);
            searchField.setFieldLayoutType(1);
            fields.add(searchField);

            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            contentList.add(globalSearchContent);
        }
        return contentList;
    }

    /**
     * athena搜索的任务卡或者项目卡条目数据
     *
     * @param searchResult
     * @param searchCategoryId
     * @param searchContent
     * @param locale
     * @param globalSearchType
     * @param tenantId
     * @param iamUserToken
     * @return
     */
    private List<GlobalSearchContent> buildAthenaProjectOrTaskGlobalSearchData(List<DigiwinAtmcSearchResult> searchResult,
                                                                               String searchCategoryId,
                                                                               String searchContent,
                                                                               String locale,
                                                                               String globalSearchType,
                                                                               String tenantId,
                                                                               String iamUserToken) {
        List<GlobalSearchContent> contentList = new ArrayList<>(searchResult.size());
        List<GlobalSearchContent> unReadAbleList = new ArrayList<>(searchResult.size());
        String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        for (DigiwinAtmcSearchResult result : searchResult) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType(GlobalSearchItemList.COMPONENT_TYPE);
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            Action action = new Action();
            //任务或者项目前面加上图标
            if (GLOBAL_SEARCH_TYPE_TASK.equalsIgnoreCase(globalSearchType)) {
                contentData.setIconData(58937);
                action = Action.getTaskAction(pageTaskRelationService, digiwinAtmcProxyService,
                        localeService, customTaskConfigService, result, locale, tenantId, iamUserToken, activityFilterService, tenantVersion);
            } else if (GLOBAL_SEARCH_TYPE_PROJECT.equalsIgnoreCase(globalSearchType)) {
                contentData.setIconData(58938);
                action = Action.getProjectAction(projectFilterService, digiwinAtmcProxyService,
                        localeService, result, locale, tenantId, iamUserToken);
            }
            contentData.setSearchType(searchCategoryId);
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            if (action.getNoSupport()) {
                List<Label> labelList = contentData.getLabelList();
                labelList.add(Label.create(localeService.getLanguageValue(locale, "不可查阅"), LabelTypeEnum.UNREADABLE.getType()));
                contentData.setReadable(false);
            }
            contentData.setAction(action);

            List<SmartPreciseSearchField> fields = new ArrayList<>(1);
            SmartPreciseSearchField searchField = new SmartPreciseSearchField();
            searchField.setFieldId(String.valueOf(result.getId()));
            //为任务时，截取结束时间+任务名称
            if (GLOBAL_SEARCH_TYPE_TASK.equals(result.getType())) {
                searchField.setFieldValue(DateTimeUtil.getMonthDateOfTime(result.getEndTime())
                        + LocaleUtil.getMobileTextByKey(locale, "需完成") + " " + result.getName());
            } else {
                searchField.setFieldValue(DateTimeUtil.getMonthDateOfTime(result.getStartTime()) + "~"
                        + DateTimeUtil.getMonthDateOfTime(result.getEndTime()) + " " + result.getName());
            }
            searchField.setSkip(false);
            searchField.setFieldLayoutType(1);
            fields.add(searchField);
            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            if (action.getNoSupport()) {
                unReadAbleList.add(globalSearchContent);
            } else {
                contentList.add(globalSearchContent);
            }
        }
        contentList.addAll(unReadAbleList);
        return contentList;
    }

    /**
     * 聚合拿到全部信息
     *
     * @param knowledgeInfos
     * @param iamUserToken
     * @param locale
     * @param tenantId
     * @param searchCategoryId
     * @param searchContent
     * @return
     */
    private List<GlobalSearchData> buildGlobalSearchModel(Map<String, Object> knowledgeInfos,
                                                          String iamUserToken, String locale,
                                                          String tenantId, String searchCategoryId,
                                                          String searchContent) {
        List<GlobalSearchData> globalSearchData = new ArrayList<>(4);
        List<DigiwinAtmcSearchResult> searchResult = digiwinAtmcProxyService.getSearchResult(iamUserToken, locale, searchContent, tenantId);
        //全部数据
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchAllData.setName(LocaleUtil.getMobileTextByKey(locale, "全部"));
        searchAllData.setSearchCategoryId(searchCategoryId);
        searchAllData.setUseExpand(false);
        searchAllData.setCountNumText("");
        searchAllData.setShowSearchBox(true);
        searchAllData.setEntryJump(true);
        searchAllData.setUsePaging(false);
        searchAllData.setContentList(Collections.emptyList());
        List<GlobalSearchData> allContent = new ArrayList<>();


        //任务数据
        GlobalSearchData searchTaskData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale,
                LocaleUtil.getMobileTextByKey(locale, "任务"), searchContent,
                GLOBAL_SEARCH_TYPE_TASK, SearchCategoryEnum.ATHENA_TASK.getValue(), tenantId, iamUserToken);
        dealWithGlobalSearchData(searchTaskData, allContent, false);


        //项目数据
        GlobalSearchData searchProjectData = this.buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale,
                LocaleUtil.getMobileTextByKey(locale, "项目"), searchContent,
                GLOBAL_SEARCH_TYPE_PROJECT, SearchCategoryEnum.ATHENA_PROJECT.getValue(), tenantId, iamUserToken);

        dealWithGlobalSearchData(searchProjectData, allContent, false);

        //问题数据
        knowledgeInfos.put("search_range", SearchCategoryEnum.QUESTION.getValue());
        Map<String, Object> kbsSearchResultMap = this.digiwinKbsService.getInfoBaseHome(knowledgeInfos, iamUserToken, locale);
        GlobalSearchData searchKbsData = this.buildKbsGlobalSearchModel(
                kbsSearchResultMap, locale, SearchCategoryEnum.QUESTION.getValue(), SearchCategoryEnum.KBS_QUESTION.getValue(), searchContent);

        dealWithGlobalSearchData(searchKbsData, allContent, true);

        searchAllData.setAllContent(allContent);
        globalSearchData.add(searchAllData);
        globalSearchData.add(searchTaskData);
        globalSearchData.add(searchProjectData);
        globalSearchData.add(searchKbsData);
        return globalSearchData;
    }

    /**
     * 处理聚合搜索全部数据（整合项目、任务、问题）的方法
     *
     * @param searchData 调用外部API获得的搜索数据
     * @param allContent 待处理的聚合搜索数据列表
     * @param usePaging  是否使用分页
     */
    private void dealWithGlobalSearchData(GlobalSearchData searchData, List<GlobalSearchData> allContent,
                                          boolean usePaging) {
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchData.setUsePaging(usePaging);
        BeanUtils.copyProperties(searchData, searchAllData);
        if (searchData.getContentList().size() > SHOW_MORE_SIZE) {
            searchData.setUseExpand(true);
            searchAllData.setUseExpand(true);
            allContent.add(buildGlobalSearchData(searchData, searchAllData));
        } else {
            searchAllData.setCountNumText("");
            searchAllData.setUsePaging(false);
            searchAllData.setUseExpand(false);
            searchData.setUseExpand(false);
            if (searchData.getContentList().size() != 0) {
                allContent.add(searchAllData);
            }

        }
    }

    private GlobalSearchData buildGlobalSearchData(GlobalSearchData searchData, GlobalSearchData searchAllTaskData) {
        searchAllTaskData.setCountNumText("");
        List<GlobalSearchContent> newContent = new ArrayList<>(3);
        List<GlobalSearchContent> oldContent = searchData.getContentList();
        int i = 0;
        for (GlobalSearchContent content : oldContent) {
            if (i == 3) {
                break;
            }
            i++;
            newContent.add(content);
        }
        searchAllTaskData.setContentList(newContent);
        return searchAllTaskData;
    }

    /**
     * 聚合搜索，不带知识中台的全部信息
     *
     * @param searchResult
     * @param locale
     * @param searchCategoryId
     * @param searchContent
     * @param tenantId
     * @param iamUserToken
     * @return
     */
    private List<GlobalSearchData> buildAthenaGlobalSearchModel(List<DigiwinAtmcSearchResult> searchResult,
                                                                String locale, String searchCategoryId, String searchContent, String tenantId, String iamUserToken) {
        List<GlobalSearchData> dataList = new ArrayList<>();

        //全部数据
        GlobalSearchData searchAllData = new GlobalSearchData();
        searchAllData.setName(LocaleUtil.getMobileTextByKey(locale, "全部"));
        searchAllData.setSearchCategoryId(searchCategoryId);
        searchAllData.setUseExpand(false);
        searchAllData.setCountNumText("");
        searchAllData.setShowSearchBox(true);
        searchAllData.setEntryJump(true);
        searchAllData.setUsePaging(false);
        searchAllData.setContentList(Collections.emptyList());

        List<GlobalSearchData> allContent = new ArrayList<>();
        GlobalSearchData searchTaskData = buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale,
                LocaleUtil.getMobileTextByKey(locale, "任务"), searchContent,
                GLOBAL_SEARCH_TYPE_TASK, searchCategoryId, tenantId, iamUserToken);
        dealWithGlobalSearchData(searchTaskData, allContent, false);


        GlobalSearchData searchProjectData = buildAthenaProjectOrTaskGlobalSearchModel(searchResult, locale,
                LocaleUtil.getMobileTextByKey(locale, "项目"), searchContent,
                GLOBAL_SEARCH_TYPE_PROJECT, searchCategoryId, tenantId, iamUserToken);
        dealWithGlobalSearchData(searchProjectData, allContent, false);

        searchAllData.setAllContent(allContent);
        dataList.add(searchAllData);
        dataList.add(searchProjectData);
        dataList.add(searchTaskData);
        return dataList;
    }

    private Map<String, Object> doMockData(String locale) {
        String data = FileUtil.readText("static/appstore-use/global-search-question.json");
        return JsonUtil.jsonStringToObject(data, Map.class);
    }

    /**
     * 构建知识中台的搜索结果
     *
     * @param kbsSearchResultMap
     * @param locale
     * @param searchCategoryId
     * @param searchContent
     * @return
     */
    private GlobalSearchData buildKbsGlobalSearchModel(Map<String, Object> kbsSearchResultMap, String locale,
                                                       String searchCategoryId, String returnSearchCategoryId, String searchContent) {
        // 空值防护处理
        if (CollectionUtils.isEmpty(kbsSearchResultMap)) {
            GlobalSearchData globalSearchData = new GlobalSearchData();
            globalSearchData.setSearchCategoryId(returnSearchCategoryId);
            globalSearchData.setName(LocaleUtil.getMobileTextByKey(locale, "问题"));

            globalSearchData.setShowSearchBox(true);

            globalSearchData.setContentList(Collections.emptyList());
            globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), 0));

            return globalSearchData;
        }
        List<Map<String, Object>> knowledgeInfos = (List<Map<String, Object>>) kbsSearchResultMap.get("knowledge_info");
        Pagination pagination = JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(kbsSearchResultMap.get("pagination")), Pagination.class);
        GlobalSearchData globalSearchData = new GlobalSearchData();
        globalSearchData.setSearchCategoryId(returnSearchCategoryId);
        globalSearchData.setName(LocaleUtil.getMobileTextByKey(locale, "问题"));

        globalSearchData.setShowSearchBox(true);
        globalSearchData.setEntryJump(true);
        globalSearchData.setPagination(pagination);
        if (knowledgeInfos == null || knowledgeInfos.size() < 1) {
            globalSearchData.setContentList(Collections.emptyList());
            globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), 0));

            return globalSearchData;
        } else {
            globalSearchData.setCountNumText(String.format(LocaleUtil.getMobileTextByKey(locale, "总计"), knowledgeInfos.size()));
        }
        // 获取栏位标记的tag
        List<ColumnTag> columnTagList = columnTagService.listColumnTagsByPathAndPageId(searchCategoryId, PageSettingIdPresetEnum.MOBILE_ATHENA_SEARCH_ITEM_LIST.toString());

        globalSearchData.setContentList(buildKbsQuestGlobalSearchContentList(knowledgeInfos, "question", columnTagList, locale, searchContent));
        return globalSearchData;
    }

    /**
     * 知识中台的data数据
     *
     * @param knowledgeInfos
     * @param searchCategoryId
     * @param columnTagList
     * @param locale
     * @param searchContent
     * @return
     */
    private List<GlobalSearchContent> buildKbsQuestGlobalSearchContentList(List<Map<String, Object>> knowledgeInfos, String searchCategoryId, List<ColumnTag> columnTagList, String locale, String searchContent) {
        List<GlobalSearchContent> contentList = new ArrayList<>(knowledgeInfos.size());
        for (Map<String, Object> knowledgeInfo : knowledgeInfos) {
            GlobalSearchContent globalSearchContent = new GlobalSearchContent();
            globalSearchContent.setComponentType(GlobalSearchItemList.COMPONENT_TYPE);
            GlobalSearchContentData contentData = new GlobalSearchContentData();
            contentData.setStyleType(SmartPreciseSearchStyleTypeEnum.TEXT_ONLY.getValue());
            contentData.setSearchType(searchCategoryId);
            Action action = new Action((String) knowledgeInfo.get("knowledge_id"),
                    PageSettingIdPresetEnum.MOBILE_ATHENA_SEARCH_ITEM_DETAIL.toString(),
                    ActionTypeEnum.OPEN_NEW_PAGE.getValue(), knowledgeInfo);
            contentData.setAction(action);
            List<SmartPreciseSearchField> fields = new ArrayList<>(columnTagList.size());
            for (ColumnTag columnTag : columnTagList) {
                SmartPreciseSearchField field = new SmartPreciseSearchField();
                field.setFieldId(columnTag.getSchema());
                if (StringUtils.hasLength(columnTag.getmLabelText().get(locale))) {
                    field.setFieldValue(knowledgeInfo.get(columnTag.getSchema()) + columnTag.getmLabelText().get(locale));
                } else {
                    //这里需要强制截取关键字做高亮
                    String knowledgeInfoContent = "";
                    if ("knowledge_content".equals(columnTag.getSchema())) {
                        knowledgeInfoContent = (String) knowledgeInfo.get(columnTag.getSchema());
                        if (knowledgeInfoContent != null && knowledgeInfoContent.contains(searchContent)) {
                            int first = knowledgeInfoContent.indexOf(searchContent);
                            if (first > 15) {
                                knowledgeInfoContent = knowledgeInfoContent.substring(first - 15);
                            }

                        }
                    } else {
                        knowledgeInfoContent = (String) knowledgeInfo.get(columnTag.getSchema());
                    }
                    field.setFieldValue(knowledgeInfoContent);
                }
                field.setFieldLayoutType(columnTag.getParallel() == null ? 1 : (columnTag.getParallel() ? 2 : 1));
                field.setSkip(columnTag.getSkip() == null ? false : columnTag.getSkip());
                fields.add(field);
            }
            contentData.setFields(fields);
            globalSearchContent.setData(contentData);
            contentList.add(globalSearchContent);
        }
        return contentList;
    }

}
