package com.digiwin.mobile.mobileuibot.search;

import java.util.Objects;

/**
 * <p>功能描述：聚合搜索详情页固定名称枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SearchItemDetailFixedNameEnum
 * @Author: Liux
 * @Date: 2022年6月10日 16点16分
 */
public enum SearchItemDetailFixedNameEnum {

    /**
     * 阅读
     */
    READ_NUM_NAME("阅读"),
    /**
     * 问题描述
     */
    QUESTION_DESCRIPTION("问题描述"),
    /**
     * 问题图片
     */
    QUESTION_PICTURE("问题图片"),
    /**
     * 问题解决方案
     */
    QUESTION_SOLUTION("问题解决方案"),

    /**
     * 聚合搜索详情页附件
     */
    SEARCH_ITEM_DETAIL_ATTACHMENT("附件");

    private final String value;

    SearchItemDetailFixedNameEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static SearchItemDetailFixedNameEnum getEnumByValue(String value) {
        for (SearchItemDetailFixedNameEnum testedEnum : SearchItemDetailFixedNameEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
