package com.digiwin.mobile.mobileuibot.search;

import java.util.Objects;

/**
 * <p>功能描述：聚合搜索详情页样式类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SearchItemDetailTyleEnum
 * @Author: Liux
 * @Date: 2022年6月10日 16点16分
 */
public enum SearchItemDetailStyleEnum {
    /**
     * 标题的样式类型,1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
     */
    TITLE_STYLE_TYPE_ONE(1),
    /**
     * 标题的样式类型,1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
     */
    TITLE_STYLE_TYPE_TWO(2),
    /**
     * 标题的样式类型,1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
     */
    TITLE_STYLE_TYPE_THREE(3),

    /**
     * 次要内容样式,1-标题弱化，呈灰色
     */
    MINOR_CONTENT_STYLE_ONE(1);

    private final Integer value;

    SearchItemDetailStyleEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static SearchItemDetailStyleEnum getEnumByValue(Integer value) {
        for (SearchItemDetailStyleEnum testedEnum : SearchItemDetailStyleEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }

}
