package com.digiwin.mobile.mobileuibot.search.model;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 聚合搜索的条目数据
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GlobalSearchContentData implements Serializable {
    private static final long serialVersionUID = -5203047226464215384L;

    /**
     * 条目要展示的字段
     */
    private List<SmartPreciseSearchField> fields;
    /**
     * 条目包含的点击时间
     */
    private Action action;
    /**
     * 查询类型
     */
    private String searchType;
    /**
     * 条目展示类型
     */
    private Integer styleType;
    /**
     * 当任务卡和项目卡条目前面可能会有图标
     */
    private Integer iconData;
    /**
     * 文字后的标签
     */
    private List<Label> labelList = new ArrayList<>(3);
    /**
     * 是否可查阅
     */
    private Boolean readable = true;

    /**
     * 按钮
     */
    private List<Button> buttonList;
}
