package com.digiwin.mobile.mobileuibot.search.model;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.proxy.kbs.model.Pagination;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 聚合搜索的返回数据
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GlobalSearchData extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 2128876533862079836L;
    public static final String COMPONENT_TYPE = "GLOBAL_SEARCH_ITEM_LIST";

    /**
     * 名称
     */
    private String name;
    /**
     * 所属key
     */
    private String searchCategoryId;
    /**
     * 是否允许点击条目跳转
     */
    private Boolean entryJump;
    /**
     * 是否使用分页
     */
    private Boolean usePaging;
    /**
     * 是否显示更多
     */
    private Boolean useExpand = false;
    /**
     * 分页参数
     */
    private Pagination pagination;
    /**
     * 是否显示搜索框
     */
    private Boolean showSearchBox;
    /**
     * 总计条数
     */
    private String countNumText;
    /**
     * 搜索的内容
     */
    private List<GlobalSearchContent> contentList;
    /**
     * 有且仅当为all的时候，他会有值
     */
    private List<GlobalSearchData> allContent;

    @Override

    public String returnComponentType() {
        return GlobalSearchData.COMPONENT_TYPE;
    }
}
