package com.digiwin.mobile.mobileuibot.search.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.*;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyang
 */
@Component("smartPreciseSearchListBuilder")
public class SmartPreciseSearchListBuilder implements MobileComponentListBuilder<SmartPreciseSearch> {

    private static final Logger logger = LoggerFactory.getLogger(SmartPreciseSearchListBuilder.class);

    @Autowired
    private ColumnTagService columnTagService;

    @Override
    public String getMobileComponentType() {
        return SmartPreciseSearch.COMPONENT_TYPE;
    }

    @Override
    public List<SmartPreciseSearch> build(ApiRequest apiRequest, PageSetting pageSetting,
                                          UiBotModel pcUiBotModel, Class<SmartPreciseSearch> clazz, Object... args) {
        Assert.notNull(args[0], "params from search must be NOT null!");
        Assert.notNull(args[1], "tmActivityId must be NOT null!");

        Object searchParams = args[0];
        String tmActivityId = (String) args[1];

        List<UiBotLayout> uiBotLayouts = pcUiBotModel.getLayout();
        if (uiBotLayouts == null || uiBotLayouts.isEmpty()) {
            return Collections.emptyList();
        }

        UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();
        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        if (tableColumnDefinitionList == null) {
            return Collections.emptyList();
        }
        // 分解出明细数据行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);
        if (args.length == 4) {
            String path = (String) args[2];
            Map<String, Object> dataKeyMatchedBizData = (Map<String, Object>) args[3];

            List<Map<String, Object>> bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath(path, dataKeyMatchedBizData);
            //抓取tag
            List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(path, apiRequest.getPageId());
            return this.getItemListByBizDataAndColumnTag(apiRequest, path, tableColumns, bizDataList,
                    columnTagList, pcUiBotModel, searchParams, tmActivityId);
        } else {
            String schema = pcUiBotModel.searchBizDataSchema();
            // 因为是TABLE类型的layout，所以数据一定是数组
            List<Map<String, Object>>
                    bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
            Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");
            if (bizDataList.isEmpty()) {
                return Collections.emptyList();
            }
            //抓取tag
            List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId());
            return this.getItemListByBizDataAndColumnTag(apiRequest, schema, tableColumns, bizDataList,
                    columnTagList, pcUiBotModel, searchParams, tmActivityId);
        }

    }

    private List<Map<String, Object>> getDeepestBizDataByDataKeyMatchedBizDataAndPath(String path,
                                                                                      Map<String, Object> datakeyMatchedBizData) {
        List<Map<String, Object>> bizDataList = new ArrayList<>();
        int firstDotIdx = path.indexOf(".");
        List<String> pathSeperated = new ArrayList<>();
        if (firstDotIdx == -1) {
            pathSeperated.add(path);
        } else {
            pathSeperated.add(path.substring(0, firstDotIdx));
            pathSeperated.add(path.substring(firstDotIdx + 1));
        }
        for (int i = 0; i < pathSeperated.size(); i++) {
            String partOfPath = pathSeperated.get(i);
            if (datakeyMatchedBizData.containsKey(partOfPath)) {
                Object tempData = datakeyMatchedBizData.get(partOfPath);
                if (tempData instanceof Map) {
                    if (i == pathSeperated.size() - 1) {
                        bizDataList.add((Map<String, Object>) tempData);
                        break;
                    }
                    bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath(
                            pathSeperated.get(i + 1), (Map<String, Object>) tempData);
                } else if (tempData instanceof List) {
                    if (i == pathSeperated.size() - 1) {
                        bizDataList = (List<Map<String, Object>>) tempData;
                        break;
                    }
                    bizDataList = this.getDeepestBizDataByDataKeyMatchedBizDataAndPath(
                            pathSeperated.get(i + 1), ((List<Map<String, Object>>) tempData).get(0));
                } else {

                }
            }
        }
        return bizDataList;
    }

    private List<SmartPreciseSearch> getItemListByBizDataAndColumnTag(
            ApiRequest apiRequest, String path, List<UiBotTableColumn> tableColumns,
            List<Map<String, Object>> bizDataList, List<ColumnTag> columnTagList, UiBotModel pcUiBotModel,
            Object searchParams, String tmActivityId) {
        Map<String, UiBotTableColumn> tableColumnMap =
                tableColumns.stream().collect(Collectors.toMap(UiBotTableColumn::getSchema, c -> c, (c1, c2) -> c1));
        // 次要字段tag
        List<ColumnTag> profileTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());
        //图片字段tag
        List<ColumnTag> picTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_PIC.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());
        //分组字段tag
        List<ColumnTag> groupTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase(path) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());

        List<SmartPreciseSearch> smartPreciseSearches = new ArrayList<>(bizDataList.size());
        List<SmartPreciseSearchField> smartPreciseSearchFields = new ArrayList<>(profileTagList.size());
        for (ColumnTag columnTag : profileTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (columnTag.getSchema().equals(column.getSchema())) {
                    smartPreciseSearchField.setFieldId(columnTag.getSchema());
                    smartPreciseSearchField.setFieldLayoutType(columnTag.getParallel() == true ?
                            SmartPreciseSearchFieldLayoutType.PARALLEL_TRUE.getValue() :
                            SmartPreciseSearchFieldLayoutType.PARALLEL_FALSE.getValue());
                    if (columnTag.getShowTitle() == null || columnTag.getShowTitle()) {
                        smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                    } else {
                        smartPreciseSearchField.setFieldTitle("");
                    }
                    //是否支持字段跳转
                    Boolean canSkip = false;
                    if (columnTag.getSkip() != null) {
                        canSkip = columnTag.getSkip();
                    }
                    smartPreciseSearchField.setSkip(canSkip);
                    if (canSkip) {
                        SkipConfig skipConfig = columnTag.getSkipConfig();
                        if (skipConfig == null) {
                            skipConfig = new SkipConfig();
                        }
                        skipConfig.setTaskCode((String) column.getExtendParas().get("taskCode"));
                        skipConfig.setQueryName((String) column.getExtendParas().get("queryName"));
                        smartPreciseSearchField.setSkipConfig(skipConfig);
                    }
                    break;
                }
            }
            smartPreciseSearchFields.add(smartPreciseSearchField);
        }

        for (ColumnTag columnTag : groupTagList) {
            SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
            for (UiBotTableColumn column : tableColumns) {
                if (columnTag.getSchema().equals(column.getSchema())) {
                    smartPreciseSearchField.setFieldId(columnTag.getSchema());
                    //是否字段并行
                    Boolean isParallel = false;
                    if (columnTag.getParallel() != null) {
                        isParallel = columnTag.getParallel();
                    }
                    smartPreciseSearchField.setFieldLayoutType(isParallel == true ?
                            SmartPreciseSearchFieldLayoutType.PARALLEL_TRUE.getValue() :
                            SmartPreciseSearchFieldLayoutType.PARALLEL_FALSE.getValue());
                    smartPreciseSearchField.setFieldTitle(column.getHeaderName());
                    break;
                }
            }
            smartPreciseSearchFields.add(smartPreciseSearchField);
        }

        //指定逻辑，看图片字段存储在几个层级下
        List<SmartPreciseSearchField> picSmartPreciseSearchField = new ArrayList<>(picTagList.size());
        for (ColumnTag columnTag : picTagList) {
            int i = 0;
            String schema = columnTag.getSchema();
            String[] schemas = schema.split("\\.");
            if (schemas.length > 0) {
                for (String s : schemas) {
                    SmartPreciseSearchField smartPreciseSearchField = new SmartPreciseSearchField();
                    smartPreciseSearchField.setFieldId(s);
                    smartPreciseSearchField.setLevel(i);
                    picSmartPreciseSearchField.add(smartPreciseSearchField);
                    i++;
                }
            }
        }

        for (Map<String, Object> bizData : bizDataList) {
            SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
            String dataKey = PcUiBotPageDataUtil.getBizDataKey(pcUiBotModel, path, bizData);
            smartPreciseSearch.setDataKey(dataKey);
            List<SmartPreciseSearchField> newSmartPreciseSearchFields = new ArrayList<>(smartPreciseSearchFields.size());
            //塞入其他字段
            for (SmartPreciseSearchField smartPreciseSearchField : smartPreciseSearchFields) {
                SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                if (bizData.get(smartPreciseSearchField.getFieldId()) == null) {
                    smartPreciseSearchField.setFieldValue("");
                } else {
                    smartPreciseSearchField.setFieldValue(String.valueOf(bizData.get(smartPreciseSearchField.getFieldId())));
                }
                BeanUtils.copyProperties(smartPreciseSearchField, searchField);
                newSmartPreciseSearchFields.add(searchField);
            }
            //塞入图片字段,目前看最多2层 todo 后续在优化
            List<Map<String, Object>> list = new ArrayList<>();
            for (SmartPreciseSearchField smartPreciseSearchField : picSmartPreciseSearchField) {
                if (smartPreciseSearchField.getLevel() == 0) {
                    list = (List<Map<String, Object>>) bizData.get(smartPreciseSearchField.getFieldId());
                } else {
                    List<Pic> picList = new ArrayList<>();
                    if (list != null && list.size() != 0) {
                        Map<String, Object> params = list.get(0);
                        Pic pic = new Pic();
                        pic.setPicUrl((String) params.get(smartPreciseSearchField.getFieldId()));
                        picList.add(pic);
                        smartPreciseSearch.setPics(picList);
                    }
                }
            }
            // 点击操作
            Map<String, Object> actionRawData = new HashMap<>(4);
            actionRawData.put("dataKey", dataKey);
            actionRawData.put("params", searchParams);
            actionRawData.put("searchQ", "");
            actionRawData.put("tmActivityId", tmActivityId);
            Action action = new Action(apiRequest.getDataId(),
                    PageSettingIdPresetEnum.MOBILE_SEARCH_ITEM_DETAIL.toString(), "",
                    ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(), actionRawData);
            smartPreciseSearch.setAction(action);
            smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
            smartPreciseSearch.setFields(newSmartPreciseSearchFields);
            smartPreciseSearches.add(smartPreciseSearch);
        }
        return smartPreciseSearches;

    }
}
