package com.digiwin.mobile.mobileuibot.search.service;

import com.digiwin.mobile.mobileuibot.core.component.search.SmartFuzzySearch;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearch;

import java.util.List;
import java.util.Map;

/**
 * 移动搜索组件业务
 *
 * @author wuyang
 */
public interface MobileSearchService {


    /**
     * 移动搜索组件--模糊搜索
     *
     * @param tenantId
     * @param question
     * @param ext
     * @param iamUserToken
     * @return
     */
    List<SmartFuzzySearch> findFuzzySearch(String tenantId, String question,
                                           Map<String, String> ext, String iamUserToken);

    /**
     * 移动搜索组件--精准搜索
     *
     * @param tenantId
     * @param question
     * @param sid
     * @param ext
     * @param iamUserToken
     * @param locale
     * @param apiRequest
     * @return
     */
    List<SmartPreciseSearch> findPreciseSearches(String tenantId, String question,
                                                 String sid, Map<String, String> ext, String iamUserToken, String locale, Map<String, String> apiRequest);

    /**
     * 移动搜索组件--精准搜索-
     *
     * @param tmActivityId
     * @param inquiryNo
     * @param iamUserToken
     * @param locale
     * @param apiRequest
     * @return
     */
    List<SmartPreciseSearch> findDirectPreciseSearches(String tmActivityId, String inquiryNo,
                                                       String iamUserToken, String tenantId,
                                                       String locale, Map<String, String> apiRequest);

    List<SmartPreciseSearch> simpleShow(String tmActivityId, Map<String, Object> map, String iamUserToken, String tenantId,
                                        String locale, Object params, Map<String, String> apiRequest);
}
