package com.digiwin.mobile.mobileuibot.search.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.search.*;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaExt;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaRequest;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QaResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.model.QuestionCompletionResponse;
import com.digiwin.mobile.mobileuibot.proxy.search.service.SearchService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.search.model.SmartPreciseSearchListBuilder;
import com.digiwin.mobile.mobileuibot.search.service.MobileSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Service("mobileSearchService")
public class MobileSearchServiceImpl implements MobileSearchService {

    /**
     * 询价单
     */
    public static final String DDC_INQUIRY_LIST = "ddc_inquiry_list";
    /**
     * 料号、图号
     */
    public static final String DDC_ITEMATTRIBUTE_LIST = "ddc_itemAttribute_list";


    @Autowired
    private SearchService searchService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private SmartPreciseSearchListBuilder smartPreciseSearchListBuilder;

    @Override
    public List<SmartFuzzySearch> findFuzzySearch(String tenantId, String question,
                                                  Map<String, String> ext, String iamUserToken) {
        List<QuestionCompletionResponse> qcr = searchService.questionCompletion(tenantId, question, ext, iamUserToken);
        if (qcr != null && qcr.size() > 0) {
            List<SmartFuzzySearch> smartFuzzySearches = new ArrayList<>(qcr.size());
            for (QuestionCompletionResponse questionCompletionResponse : qcr) {
                SmartFuzzySearch search = new SmartFuzzySearch();
                // 设置下一次搜索的类型
                search.setSearchType(SmartSearchTypeEnum.PRECISE_SEARCH.getValue());
                search.setText(questionCompletionResponse.getRecommend());
                search.setEnterIconData(59125);
                search.setSearchIconData(59124);
                smartFuzzySearches.add(search);
            }
            return smartFuzzySearches;
        } else {
            return null;
        }
    }

    @Override
    public List<SmartPreciseSearch> findPreciseSearches(String tenantId, String question,
                                                        String sid, Map<String, String> ext, String iamUserToken, String locale, Map<String, String> apiRequest) {
        List<Map<String, Object>> answers = this.getQaAnswers(tenantId, question, sid, ext, iamUserToken);
        if (answers == null) {
            return null;
        }
        Object params = answers.get(0).get("params");
        Map<String, Object> map = new HashMap<>(1);
        map.put("params", params);
        String tmActivityId = (String) answers.get(0).get("intent_code");
        List<SmartPreciseSearch> smartPreciseSearches = simpleShow(tmActivityId, map, iamUserToken, tenantId, locale, params, apiRequest);
        for (SmartPreciseSearch smartPreciseSearch : smartPreciseSearches) {
            Map<String, Object> parm = new HashMap<>();
            parm.put("iamUserToken", iamUserToken);
            parm.put("locale", locale);
            parm.put("question", question);
            parm.put("sid", sid);
            parm.put("tenantId", tenantId);
            smartPreciseSearch.setQueryInfo(params);
            if (DDC_ITEMATTRIBUTE_LIST.equals(tmActivityId)) {
                smartPreciseSearch.setStyleType(1);
            } else if (DDC_INQUIRY_LIST.equals(tmActivityId)) {
                smartPreciseSearch.setStyleType(6);
            } else {
                smartPreciseSearch.setStyleType(1);
            }
            smartPreciseSearch.setTmActivityId(tmActivityId);
            for (SmartPreciseSearchField searchField : smartPreciseSearch.getFields()) {
                if (searchField.getSkip() != null && searchField.getSkip()) {
                    if ("inquiry_no".equals(searchField.getFieldId())) {
                        parm.put("inquiry_no", searchField.getFieldValue());
                    }
                    SkipConfig skipConfig = searchField.getSkipConfig();
                    Map<String, Object> para = skipConfig.getParams();
                    for (String key : para.keySet()) {
                        Object o = para.get(key);
                        if (o instanceof String) {
                            if (StringUtils.isEmpty(o)) {
                                para.put(key, parm.get(key));
                            }
                        } else {
                            para.put(key, parm.get(key));
                        }
                    }
                } else {
                    continue;
                }
            }
            smartPreciseSearch.setTmActivityId(tmActivityId);
        }
        return smartPreciseSearches;
    }

    /**
     * @param tmActivityId
     * @param map          请求参数
     *                     图号精准搜索：
     *                     {
     *                     "query_info": [
     *                     {
     *                     "is_select_history_version": true,
     *                     "query_intent_content": "315",
     *                     "user_depart": null,
     *                     "user_id": "ppm08",
     *                     "user_role": null
     *                     }
     *                     ]
     *                     }
     *                     询价单精准搜索
     *                     {
     *                     "inquiry_detail": [
     *                     {
     *                     "inquiry_no": "31X-20220222001"
     *                     }
     *                     ]
     *                     }
     * @param iamUserToken
     * @param locale
     * @param params
     * @param apiRequest
     * @return
     */
    @Override
    public List<SmartPreciseSearch> simpleShow(String tmActivityId, Map<String, Object> map, String iamUserToken,
                                               String tenantId, String locale, Object params, Map<String, String> apiRequest) {
        UiBotModel uiBotModel = digiwinPcUiBotProxyService.simpleShow(tmActivityId, map, iamUserToken, tenantId, locale);
        ApiRequest apiRequest1 = new ApiRequest();
        apiRequest1.setPageId(apiRequest.get("pageId"));
        return this.smartPreciseSearchListBuilder.build(apiRequest1, null, uiBotModel,
                SmartPreciseSearch.class, params, tmActivityId);
    }

    @Override
    public List<SmartPreciseSearch> findDirectPreciseSearches(String tmActivityId, String inquiryNo, String iamUserToken,
                                                              String tenantId, String locale, Map<String, String> apiRequest) {
        List<Map<String, String>> inquiryNos = new ArrayList<>(1);
        Map<String, String> inquiryNoMap = new HashMap<>(1);
        inquiryNoMap.put("inquiry_no", inquiryNo);
        inquiryNos.add(inquiryNoMap);
        Map<String, Object> inquiryDetail = new HashMap<>(1);
        inquiryDetail.put("inquiry_detail", inquiryNos);
        Map<String, Object> params = new HashMap<>(1);
        params.put("params", inquiryDetail);
        tmActivityId = tmActivityId + "_detail";
        return simpleShow(tmActivityId, params, iamUserToken, tenantId, locale, params, apiRequest);
    }

    private List<Map<String, Object>> getQaAnswers(String tenantId, String question, String sid,
                                                   Map<String, String> ext, String iamUserToken) {
        QaRequest qaRequest = new QaRequest();
        qaRequest.setQuestion(question);
        qaRequest.setTenant_id(tenantId);
        qaRequest.setUid(sid);
        //todo 这里偷懒，"eoc_company_id": "Cm01","eoc_region_id": "","eoc_site_id": "001"这三个参数可不传
        QaExt qaExt = new QaExt();
        qaExt.setLocale(ext.get("locale"));
        qaExt.setTenantId(tenantId);
        qaExt.setToken(iamUserToken);
        qaExt.setUserId(ext.get("userId"));
        qaRequest.setExt(qaExt);
        QaResponse qaResponse = searchService.qa(qaRequest, iamUserToken);
        //抓取qaResponse的params去PC端抓PC端UIbot格式
        List<Map<String, Object>> answers = qaResponse.getAnswer();
        if (answers == null || answers.size() < 1) {
            return null;
        }
        return answers;
    }


}
