package com.digiwin.mobile.mobileuibot.sso;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtils;
import com.digiwin.mobile.mobileuibot.common.crypto.rsa.RSAUtils;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigIwinCamResponse;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.IamAuth;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAddJoinTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.model.ProxyRefreshTenant;
import com.digiwin.mobile.mobileuibot.sso.dto.DigiwinAppStandardSsoQueryDTO;
import com.digiwin.mobile.mobileuibot.sso.dto.ThirdPartyLoginFreeQueryDTO;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoMongoKeyEnum;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.sso.model.EnvironmentalConfiguration;
import com.digiwin.mobile.mobileuibot.sso.model.SsoConfigModel;
import com.digiwin.mobile.mobileuibot.sso.model.ThirdPartyForParticipationRequestModel;
import com.digiwin.mobile.mobileuibot.sso.service.SsoService;
import com.digiwin.mobile.mobileuibot.sso.utils.HttpRequestDeviceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

import static com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum.*;
import static com.digiwin.mobile.mobileuibot.proxy.ProxyController.*;

/**
 * @author yanfeng
 * @date 2023/7/24
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/sso")
public class SsoController {

    public static final String THIRD_PARTY_SSO_SECRET_KEY = "OkTLr7+ZtjyoGyEM";

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;


    private static LocaleService localeService;

    @Autowired
    private MongoTemplate mongoTemplate;

    private static DigiwinIamProxyService iamProxyService;

    private static DigiwinAtmcProxyService atmcProxyService;

    private static PageTaskRelationService pageTaskRelationService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigIwinCamProxyService camProxyService;

    private static ActivityFilterService activityFilterService;

    @Autowired
    public void setPageTaskRelationService(PageTaskRelationService pageTaskRelationService) {
        SsoController.pageTaskRelationService = pageTaskRelationService;
    }

    @Autowired
    public void setLocaleService(LocaleService localeService) {
        SsoController.localeService = localeService;
    }

    @Autowired
    public void setIamProxyService(DigiwinIamProxyService iamProxyService) {
        SsoController.iamProxyService = iamProxyService;
    }

    @Autowired
    public void setAtmcProxyService(DigiwinAtmcProxyService atmcProxyService) {
        SsoController.atmcProxyService = atmcProxyService;
    }

    @Autowired
    public void setActivityFilterService(ActivityFilterService activityFilterService) {
        SsoController.activityFilterService = activityFilterService;
    }


    private Map<String, SsoService> channelSourcessoServiceMap = new HashMap();

    @Autowired
    public void setSsoServiceMap(Map<String, SsoService> ssoServiceMap) {
        ssoServiceMap.forEach((k, v) -> channelSourcessoServiceMap.put(v.getSsoChannelSource(), v));
    }

    /**
     * line sso
     *
     * @param request
     * @param response
     * @return ApiResponse<String>
     * @author yanfeng
     */
    @GetMapping("/line")
    public ApiResponse handleLineSso(HttpServletRequest request, HttpServletResponse response) {
        try {
            ThirdPartyForParticipationRequestModel model = ThirdPartyForParticipationRequestModel.handleParams(request);
            SsoService ssoService = channelSourcessoServiceMap.getOrDefault(model.getChannelSource(), null);
            ApiResponse ssoResponse = null;
            if (Objects.isNull(ssoService)) {
                ssoResponse = this.handleIamSsoLogin(model);
            }
            if (ssoResponse != null) {
                if (ssoResponse.isError()) {
                    return ApiResponse.buildError(ssoResponse.getMsg());
                } else {
                    DigiwhaleLoginResponse data = (DigiwhaleLoginResponse) ssoResponse.getData();
                    model.setIamUserToken(data.getToken());
                    model.setUserId(data.getUserId());
                    model.setTenantId(data.getTenantId());
                }
            }
            // 判断是否台湾还是大陆 区  true是台湾区，false大陆区 user-agent
            Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
            //false pc  true mobile
            boolean mobileDevice = HttpRequestDeviceUtils.isMobileDevice(request);
            if (mobileDevice) {
                if (Objects.nonNull(ssoService)) {
                    return ssoService.getSsoMobileParams(response, model, isTw);
                } else {
                    return getSsoMongoMobileParams(response, model, isTw, new Query());
                }
            } else {
                if (Objects.nonNull(ssoService)) {
                    return ssoService.getSsoPcParams(response, model, isTw);
                } else {
                    return getSsoMongoPcParams(response, model, isTw, new Query());
                }
            }
        } catch (Exception e) {
            log.error("line重定向失败:{}", e.getMessage());
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * 第三方集成跳转（点击跳转任务卡）
     *
     * @param request
     * @param response
     * @return ApiResponse<String>
     * @author yanfeng
     */
    @GetMapping("/grantOauthAccess")
    public ApiResponse grantOauthAccess(HttpServletRequest request, HttpServletResponse response) {
        try {
            Query query = new Query();
            ThirdPartyForParticipationRequestModel model = ThirdPartyForParticipationRequestModel.handleParams(request);
            // 判断是否台湾还是大陆 区  true是台湾区，false大陆区
            Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
            return getSsoMongoMobileParams(response, model, isTw, query);
        } catch (Exception e) {
            log.error("grantOauthAccess重定向失败:{}", e.getMessage());
            return ApiResponse.buildError(e.getMessage());
        }
    }

    @Nullable
    private ApiResponse getSsoMongoMobileParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw, Query query) throws IOException {
        query.addCriteria(Criteria.where("key").is(SsoMongoKeyEnum.MOBILE.getSource()));
        SsoConfigModel mobileModel = mongoTemplate.findOne(query, SsoConfigModel.class);
        ApiResponse url = getRedirectUrl(mobileModel, isTw, model, true);
        if (url != null) {
            //企微直接返回url，交由semc路由那边重定向跳转
            if (SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
                log.error("企微url:{}", url);
                return ApiResponse.buildOK().setData(url);
            }
            response.sendRedirect(String.valueOf(url.getData()));
        }
        return url;
    }

    @Nullable
    private ApiResponse getSsoMongoPcParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw, Query query) throws IOException {
        query.addCriteria(Criteria.where("key").is(SsoMongoKeyEnum.PC.getSource()));
        SsoConfigModel pcModel = mongoTemplate.findOne(query, SsoConfigModel.class);
        ApiResponse url = getRedirectUrl(pcModel, isTw, model, false);
        if (url != null) {
            response.sendRedirect(String.valueOf(url.getData()));
        }
        return url;
    }


    /**
     * 鼎捷移动CN或TW SSO登录入口
     * 重定向第三方跳转页面
     *
     * @return ApiResponse<String>
     */
    @GetMapping("/digiwinapp")
    public ApiResponse<String> handleDigiwinAppStandardSso(DigiwinAppStandardSsoQueryDTO dto, HttpServletResponse response) {
        try {
            if (StringUtils.isNotBlank(dto.getSsoTargetUrl()) && StringUtils.isNotBlank(dto.getMLoginID())
                    && StringUtils.isNotBlank(dto.getMPassword())) {
                String clientAgent = CLIENT_AGENT_MOBILE + "-" + UUIDUtil.getUuid();
                String encryptUserName = AESUtil.decrypt(SECRET_KEY, dto.getMLoginID());
                String loginName = encryptUserName + LOGIN_TYPE_AD_SUFFIX_ONE;
                String encryptParamPwd = AESUtil.decrypt(SECRET_KEY, dto.getMPassword());
                String encryptPublicKey = getEncryptPublicKey();
                String passwordHash = getEncryptPwd(encryptParamPwd, encryptPublicKey);
                ResponseEntity<DigiwhaleLoginResponse> responseEntity = this.digiwinIamProxyService
                        .userLoginByAD(loginName, encryptPublicKey, passwordHash, dto.getLocale(), null, clientAgent, null, "");
                IamAuth iamAuth = Objects.requireNonNull(responseEntity.getBody()).getIamAuth();
                StringBuilder appendUrl = new StringBuilder(dto.getSsoTargetUrl());
                appendUrl.append("/#/?iamUserToken=").append(iamAuth.getToken());
                appendUrl.append("&userId=").append(iamAuth.getUserId());
                appendUrl.append("&tenantId=").append(iamAuth.getTenantId())
                        .append(dto.getSsoUrlParameter());
                String url = appendUrl.toString();
                if (!url.contains("locale")) {
                    appendUrl.append("&locale=").append(dto.getLocale());
                }
                response.sendRedirect(appendUrl.toString());
                return ApiResponse.buildOK(appendUrl.toString());
            }
        } catch (Exception e) {
            log.error("SSO验证失败:{}", e.getMessage(), e);
            return ApiResponse.buildServiceError(localeService.getLanguageValue(dto.getLocale(),
                    "SSO验证失败"), e.getMessage());
        }
        return ApiResponse.buildOK();
    }

    /**
     * 根据服务端公钥加密客户端公钥
     *
     * @return
     * @throws Exception
     */
    private String getEncryptPublicKey() throws Exception {
        // 获取服务端公钥
        String serverPublicKey = digiwinIamProxyService.doGetPublicKey();
        if (StringUtils.isEmpty(serverPublicKey)) {
            log.error("未拿到互联的公钥。。。。");
        } else {
            log.error("拿到互联公钥为：" + serverPublicKey);
        }
        // 根据服务端公钥加密客户端公钥
        return RSAUtils.encryptByPublicKey(RSAUtils.CLIENT_PUBLIC_KEY, serverPublicKey);
    }

    /**
     * RSA+AES加密密码
     *
     * @param userName
     * @param encryptPublicKey 加密后的公钥
     * @return
     * @throws Exception
     */
    private String getEncryptPwd(String userName, String encryptPublicKey) throws Exception {
        // 获取加密后的AES的key值
        String aesPrivateKey = digiwinIamProxyService.doGetAesKey(encryptPublicKey);
        // 根据客户端私钥解密 加密的aes的key值
        String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64(aesPrivateKey), RSAUtils.CLIENT_PRIVATE_KEY));
        // 拿解密后的AES的key值对密码进行aes加密
        return AESUtils.aesEncryptByBase64(userName, aesKey);
    }

    /**
     * 构建line 重定向url
     *
     * @param mobileModel
     * @param isTw
     * @param model
     * @param mobileDevice false pc  true mobile
     * @return ApiResponse<String>
     * @author yanfeng
     */
    @Nullable
    public static ApiResponse getRedirectUrl(SsoConfigModel mobileModel, Boolean isTw,
                                             ThirdPartyForParticipationRequestModel model, Boolean mobileDevice) {
        Map<String, List<EnvironmentalConfiguration>> parameterMap = mobileModel.getParameterMap();
        List<EnvironmentalConfiguration> environmentalConfigurations = isTw ? parameterMap.get(AppEnvDeployAreaEnum.TW.name()) : parameterMap.get(AppEnvDeployAreaEnum.CN.name());
        String url = haveParameterSubstitution(model, environmentalConfigurations, mobileDevice);
        log.error("获取重定向url:{}", url);
        return ApiResponse.buildOK().setData(url);
    }

    /**
     * url 参数替换
     *
     * @param model
     * @param environmentalConfigurations
     * @param mobileDevice                false pc  true mobile
     * @return String
     * @author yanfeng
     */
    @Nullable
    public static String haveParameterSubstitution(ThirdPartyForParticipationRequestModel model
            , List<EnvironmentalConfiguration> environmentalConfigurations, Boolean mobileDevice) {
        for (EnvironmentalConfiguration var : environmentalConfigurations) {
            if (AppContext.getEnvType().equalsIgnoreCase(var.getEnvironment())) {
                String parameter = handelParameter(var, model, mobileDevice);

                if (SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
                    return handEnterpriseWechatUrl(model, parameter);
                }

                if (SsoSourceTypeEnum.MOBILE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())
                        || SsoSourceTypeEnum.LINE.getSource().equalsIgnoreCase(model.getSourceType())) {
                    if (BooleanUtils.isFalse(mobileDevice)) {
                        //pc端url
                        return parameter.replace("{iamUserToken}", model.getIamUserToken());
                    } else {
                        return loginSsoUrl(model, parameter);
                    }
                }

                if (StringUtils.isNotBlank(model.getIamUserToken())) {
                    return loginSsoUrl(model, parameter);
                } else {
                    String replace = parameter.replace("{redirectUrl}", "login&targetUrl=render")
                            .replace("{ }", model.getTargetTenantId());
                    StringBuilder url = new StringBuilder(replace);
                    if (ObjectUtils.isNotEmpty(model.getIsHideAppBar())) {
                        url.append("&isHideAppBar=").append(model.getIsHideAppBar());
                    }
                    return String.valueOf(url);
                }
            }
        }
        return null;
    }

    public static String handelParameter(EnvironmentalConfiguration var, ThirdPartyForParticipationRequestModel model, Boolean mobileDevice) {
        String parameter = var.getParameter().replace("{muiUrl}", mobileDevice ? AppContext.getApiUrlSetting().getWebUrl() : AppContext.getApiUrlSetting().getMuiUrl())
                .replace("{local}", model.getLocal());
        if (StringUtils.isNotBlank(model.getTaskId())) {
            parameter = parameter.replace("{dataId}", model.getTaskId());
        }
        if (StringUtils.isNotBlank(model.getProxyToken())) {
            parameter = parameter.replace("{proxyToken}", model.getProxyToken());
        } else {
            parameter = parameter.replace("&proxyToken={proxyToken}", "");
        }
        if (StringUtils.isNotBlank(model.getTargetTenantId())) {
            parameter = parameter.replace("{targetTenantId}", model.getTargetTenantId());
        } else {
            parameter = parameter.replace("&targetTenantId={targetTenantId}", "");
        }
        parameter = handleNanaAppletUrl(model, parameter);
        parameter = handWeChatUrlPhaseOne(model, parameter);
        parameter = handDingTalkUrl(model, parameter);
        return parameter;
    }

    /**
     * 处理娜娜小程序
     *
     * @param model
     * @param parameter
     * @return String
     * @author yanfeng
     */
    private static String handleNanaAppletUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.NANA_APPLET.getSource().equalsIgnoreCase(model.getSourceType())) {
            authCodeSubstitutionAccessToken(model);
            handelTaskCategory(model);

            parameter = parameter.replace("&sourceType=nana", "&sourceType=nana_applet");
            if (StringUtils.isNotBlank(model.getPageId())) {
                parameter = parameter.replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId());
            } else {
                parameter = parameter.replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), MOBILE_ATHENA_EMPTY_PAGE.name());
            }
        }
        return parameter;
    }


    /**
     * 处理企微1期 url
     *
     * @param model
     * @param parameter
     * @return
     */
    private static String handWeChatUrlPhaseOne(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.MOBILE_WECHAT.getSource().equalsIgnoreCase(model.getSourceType())) {
            handleReplaceToken(model);
            handelTaskCategory(model);
            AppRequestContext.getContextEntity().setSourceType(model.getSourceType());
            parameter = parameter.replace("&sourceType=nana", "&sourceType=Wechat");
            if (StringUtils.isNotBlank(model.getTaskCategory()) && "APPROVAL".equalsIgnoreCase(model.getTaskCategory())) {
                //签核型任务替换pageId
                parameter = parameter
                        .replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.name());
            } else {
                //非签核型任务返回空页面
                parameter = parameter
                        .replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), MOBILE_ATHENA_EMPTY_PAGE.name());
            }
        }
        return parameter;
    }

    /**
     * 处理企业微信2期 url
     *
     * @param model
     * @param parameter
     * @return String
     * @author yanfeng
     */
    private static String handEnterpriseWechatUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        handleEnterpriseWechatAuthorization(model);
        parameter = parameter.replace("&sourceType=nana", "&sourceType=enterprise_Wechat");
        //组装任务详情url
        if (StringUtils.isNotBlank(model.getTaskId())) {
            handelTaskCategory(model);
            if (StringUtils.isNotBlank(model.getPageId())) {
                parameter = parameter.replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId());
            } else {
                parameter = parameter.replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), MOBILE_ATHENA_EMPTY_PAGE.name());
            }
            return loginSsoUrl(model, parameter);
        } else {
            //组装首页url
            String url;
            parameter = parameter.replace("&dataId={dataId}", "");
            if (StringUtils.isNotBlank(model.getIamUserToken())) {
                url = loginSsoUrl(model, parameter).replace("render", "home")
                        .replace("MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL", PageSettingIdPresetEnum.INDEX.name());
            } else {
                url = parameter.replace("{redirectUrl}", "login&targetUrl=render")
                        .replace("&pageId=MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL", "");
            }
            return url;
        }
    }

    /**
     * 处理钉钉第三方应用 url
     *
     * @param model
     * @param parameter
     * @return
     */
    private static String handDingTalkUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        if (SsoSourceTypeEnum.DING_TALK.getSource().equalsIgnoreCase(model.getSourceType())) {
            handelTaskCategory(model);
            if (StringUtils.isNotBlank(model.getPageId())) {
                parameter = parameter.replace("&sourceType=nana", "&sourceType=ding_talk")
                        .replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), model.getPageId());
            } else {
                parameter = parameter
                        .replace(MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name(), MOBILE_ATHENA_EMPTY_PAGE.name());
            }
        }
        return parameter;
    }

    private static String loginSsoUrl(ThirdPartyForParticipationRequestModel model, String parameter) {
        String replace = parameter.replace("{redirectUrl}", "render");
        StringBuilder url = new StringBuilder(replace);
        url.append("&iamUserToken=").append(model.getIamUserToken())
                .append("&userId=").append(model.getUserId())
                .append("&tenantId=").append(model.getTenantId());
        if (ObjectUtils.isNotEmpty(model.getIsHideAppBar())) {
            url.append("&isHideAppBar=").append(model.getIsHideAppBar());
        }
        return String.valueOf(url);
    }

    /**
     * 处理IAM 第三方系统 SSO登录
     *
     * @param model
     * @return
     */
    private ApiResponse handleIamSsoLogin(ThirdPartyForParticipationRequestModel model) {
        ThirdPartyLoginFreeQueryDTO queryDTO = new ThirdPartyLoginFreeQueryDTO();
        BeanUtils.copyProperties(model, queryDTO);
        queryDTO.setTenantId(model.getTargetTenantId());
        queryDTO.setType("line");
        DigiwhaleLoginResponse iamUserInfo = iamProxyService.identityOauthTokenGrantAccess(queryDTO);
        if (ObjectUtils.isEmpty(iamUserInfo)) {
            return ApiResponse.buildError("Line IAM SSO Fail");
        } else if (ObjectUtils.isNotEmpty(iamUserInfo.getErrorMessage())) {
            return ApiResponse.buildError(iamUserInfo.getErrorMessage());
        } else {
            return ApiResponse.buildOK().setData(iamUserInfo);
        }
    }

    /**
     * 根据免登授权码获取token
     * 免登授权码有效期5分钟，且只能使用一次
     *
     * @param model
     */
    private static void authCodeSubstitutionAccessToken(ThirdPartyForParticipationRequestModel model) {
        DigiwinIamAuthoredUser digiwhaleLoginResponse = iamProxyService.authCodeSubstitutionAccessToken(model.getCode(), model.getAppId());
        if (ObjectUtils.isNotEmpty(digiwhaleLoginResponse)) {
            model.setIamUserToken(digiwhaleLoginResponse.getToken());
            model.setUserId(digiwhaleLoginResponse.getUserId());
            model.setTenantId(digiwhaleLoginResponse.getTenantId());
        } else {
            throw new ServiceException(localeService.getLanguageValue(model.getLocal(), "SSO登录失败"));
        }
    }

    /**
     * 企微一期使用 临时token置换鼎捷token
     *
     * @param model
     */
    private static void handleReplaceToken(ThirdPartyForParticipationRequestModel model) {
        String token = iamProxyService.identityTokenTempAccess(model.getIamUserToken(), model.getTenantId(), model.getUserId(), "athena");
        if (StringUtils.isNotBlank(token)) {
            model.setIamUserToken(token);
        }
    }

    /**
     * 企微二期 企微企业授权 根据code获取鼎捷token
     *
     * @param model
     */
    private static void handleEnterpriseWechatAuthorization(ThirdPartyForParticipationRequestModel model) {
        DigiwhaleLoginResponse response = iamProxyService.identityOauthTokenAccess(model.getCode(), model.getTenantId(), "weCom", model.getAppId());
        if (!ObjectUtils.isEmpty(response)) {
            model.setIamUserToken(response.getToken());
            model.setUserId(response.getUserId());
            model.setTenantId(response.getTenantId());
        }
    }

    /**
     * 根据任务Id获取：任务分类和页面Id
     *
     * @param model
     */
    private static void handelTaskCategory(ThirdPartyForParticipationRequestModel model) {
        String iamUserToken = model.getIamUserToken();
        String tenantId = model.getTenantId();
        if (StringUtils.isNotBlank(model.getTaskId()) && StringUtils.isNotBlank(iamUserToken)) {
            //切换租户
            if (StringUtils.isNotBlank(model.getTargetTenantId()) && !model.getTargetTenantId().equalsIgnoreCase(model.getTenantId())) {
                ProxyRefreshTenant proxyRefreshTenant = ProxyRefreshTenant.create(
                        iamProxyService.tokenRefreshTenant(model.getTargetTenantId(), "", iamUserToken));
                iamUserToken = proxyRefreshTenant.getUserToken();
                tenantId = proxyRefreshTenant.getTenantId();
            }
            DigiwinAtmcBacklogDetail digiwinAtmcBacklog = atmcProxyService.getDigiwinAtmcBacklogDetailByShare(model.getLocal(), iamUserToken, model.getTaskId());
            if (ObjectUtils.isNotEmpty(digiwinAtmcBacklog) && StringUtils.isNotBlank(digiwinAtmcBacklog.getTmTaskId())) {
                model.setTaskCategory(digiwinAtmcBacklog.getTmCategory());
                String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, model.getLocal());
                List<PageTaskRelation> pageTaskRelationList =
                        activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);
                Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                        pageTaskRelationList.stream().filter(
                                        pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                                digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId()))
                                .findFirst();
                Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                                pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                        digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory()))
                        .findFirst();
                String pageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                        optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                        (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");
                model.setPageId(pageId);
            } else {
                throw new ServiceException(localeService.getLanguageValue(model.getLocal(), "查询任务失败"));
            }
        }
    }

    @RequestMapping(value = "/line/login", method = RequestMethod.POST)
    public ApiResponse<T> handLineWeChatSsoLogin(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        DigIwinCamResponse lineCamInfo = camProxyService.getLineCamInfo(params);
        if (ObjectUtils.isEmpty(lineCamInfo)) {
            return ApiResponse.buildError();
        }
        //返回正常自动登录
        //加入租户-应用授权-切换租户
        JSONObject lineInfo = JsonUtil.objectToJavaObject(lineCamInfo.getData(), JSONObject.class);
        String tenantId = lineInfo.getString("tenantId");
        String iamUserToken = lineInfo.getString("token");
        String userId = lineInfo.getString("userId");
        if (ObjectUtils.isEmpty(userId)) {
            return ApiResponse.buildOK();
        }
        String verifyUserId = lineInfo.getString("verifyUserId");
        DigiwinIamUserAddJoinTenant joinTenantResult = this.digiwinIamProxyService.userAddJoinTenant(iamUserToken
                , tenantId, "", "", "");
        joinTenantResult.setTenantId(tenantId);
        DigiwinIamTokenRefreshTenant refreshTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(joinTenantResult.getTenantId(), "", iamUserToken);
        //查询用户信息
        JSONObject userInfo = iamProxyService.getUserInfo(refreshTenantResult.getUserToken(), userId);
        if (ObjectUtils.isEmpty(userInfo)) {
            return ApiResponse.buildError();
        }
        EocPerson eocInfo = digiwinEocProxyService.getEocInfo(userInfo.getString("id"), iamUserToken);
        userInfo.put("eoc", eocInfo);
        userInfo.put("bindTenantId", tenantId);
        userInfo.put("verifyUserId", verifyUserId);
        userInfo.put("iamAuth", refreshTenantResult.getAuthoredUser());
        return ApiResponse.buildOK().setData(userInfo);

    }
}