package com.digiwin.mobile.mobileuibot.sso.enums;

import lombok.Getter;

/**
 * 功能: SSO请求来源类型
 *
 * @author: yanfeng
 * @date: 2023/12/14
 */
@Getter
public enum SsoSourceTypeEnum {

    /**
     * 企业微信一期
     */
    MOBILE_WECHAT("WeChat"),

    /**
     * C娜
     */
    NANA_APPLET("nana_applet"),

    //钉钉
    DING_TALK("ding_talk"),

    /**
     * 台湾移动端Line
     */
    LINE("Line"),

    /**
     * 企业微信二期
     */
    ENTERPRISE_WECHAT("enterprise_Wechat"),

    /**
     * 娜娜消息
     */
    NANA_MESSAGE("nana_message")
    ;


    private final String source;

    SsoSourceTypeEnum(String source) {
        this.source = source;
    }

}