package com.digiwin.mobile.mobileuibot.sso.model;

import com.digiwin.mobile.mobileuibot.sso.enums.SsoMongoKeyEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.FieldType;
import org.springframework.data.mongodb.core.mapping.MongoId;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * SSO 配置参数
 *
 * @author yanfeng
 * @date 2023/10/17
 */
@Document("ssoConfig")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SsoConfigModel implements Serializable {

    private static final long serialVersionUID = 1045554914367977108L;
    @MongoId(FieldType.OBJECT_ID)
    private String _id;

    /**
     * 业务关键key，用于查询对应的配置参数
     *
     * @see SsoMongoKeyEnum
     */
    private String key;

    /**
     * 配置参数
     * Map key(固定)： 1.CN  2.TW
     */
    private Map<String, List<EnvironmentalConfiguration>> parameterMap;

}
