package com.digiwin.mobile.mobileuibot.sso.service;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.DigIwinCamResponse;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoChannelSourceEnum;
import com.digiwin.mobile.mobileuibot.sso.model.ThirdPartyForParticipationRequestModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Description
 * @Author cai chao
 * @Date 2025/2/28 12:48
 */
@Slf4j
@Service
@SuppressWarnings("all")
public class NanaSsoServiceImpl implements SsoService {
    private static final String KEY = "550F743242C481975EDBDEDEE3498BAA";

    private static final String LINE_ACCESS_URL = "https://access.line.me/oauth2/v2.1/authorize?response_type=code&client_id={0}&scope=profile%20openid%20email&state={1}&redirect_uri={2}";
    @Autowired
    private DigIwinCamProxyService digIwinCamProxyService;

    public String getNanaLineRedirectUri() {
        return AppContext.getApiUrlSetting().getBaseHost() + "/mobile/v1/sso/line?channelSource=nana&sourceType=Line";
    }

    @Override
    public String getSsoChannelSource() {
        return SsoChannelSourceEnum.NANA.getChannelSource();
    }

    @Override
    public ApiResponse getSsoPcParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw) throws IOException {
        String url;
        String param = null;
        if (StringUtils.isBlank(model.getCode())) {
            String redirect_uri = URLEncoder.encode(getNanaLineRedirectUri(), CharsetUtil.CHARSET_UTF_8.toString());
            String state;
            if (StringUtils.isNotBlank(model.getQueryString())) {
                param = URLDecoder.decode(model.getQueryString(), CharsetUtil.CHARSET_UTF_8.toString());
                state = encrypt(param);
            } else {
                state = UUIDUtil.getUuid();
            }
            url = MessageFormat.format(LINE_ACCESS_URL, AppContext.getApiUrlSetting().getNanaLineClientId(), state, redirect_uri);
        } else {
            if (StringUtils.isNotBlank(model.getState())) {
                param = decrypt(model.getState());
            }
            Map<String, Object> lineCamInfo = queryLineCamInfo(model);
            String token = MapUtils.getString(lineCamInfo, "token");
            String verifyUserId = MapUtils.getString(lineCamInfo, "verifyUserId");
            if (StringUtils.isNotBlank(token)) {
                url = HttpUtil.urlWithForm(AppContext.getApiUrlSetting().getAniaWebUrl() + "?token=" + token, param, CharsetUtil.CHARSET_UTF_8, false);
            } else if (StringUtils.isNotBlank(verifyUserId)) {
                url = HttpUtil.urlWithForm(AppContext.getApiUrlSetting().getAniaWebUrl() + "/login/line-login" + "?verifyUserId=" + verifyUserId, param, CharsetUtil.CHARSET_UTF_8, false);
            } else {
                url = HttpUtil.urlWithForm(AppContext.getApiUrlSetting().getAniaWebUrl() + "/login/line-login", param, CharsetUtil.CHARSET_UTF_8, false);
            }
        }
        ApiResponse apiResponse = ApiResponse.buildOK().setData(url);
        if (url != null) {
            response.sendRedirect(url);
        }
        return apiResponse;
    }


    private String encrypt(String param) {
        try {
            return AESUtil.encrypt(KEY, param);
        } catch (Exception ex) {
            log.error("encrypt is error", ex);
            return UUIDUtil.getUuid();
        }
    }

    private String decrypt(String state) {
        try {
            return AESUtil.decrypt(KEY, state);
        } catch (Exception ex) {
            log.error("decrypt is error", ex);
            return null;
        }
    }

    @Override
    public ApiResponse getSsoMobileParams(HttpServletResponse response, ThirdPartyForParticipationRequestModel model, Boolean isTw) throws IOException {
        String url = AppContext.getApiUrlSetting().getWebUrl() + "?redirectUrl=nana";
        if (StringUtils.isNotBlank(model.getQueryString())) {
            url += "&queryString=" + model.getQueryString();
        }
        ApiResponse apiResponse = ApiResponse.buildOK().setData(url);
        if (apiResponse != null) {
            response.sendRedirect(url);
        }
        return apiResponse;
    }

    private String getLineCamInfo(ThirdPartyForParticipationRequestModel model, String url) {
        Map<String, Object> params = new HashMap();
        params.put("code", model.getCode());
        params.put("appId", "Athena");
        params.put("redirectUri", getNanaLineRedirectUri());
        params.put("clientId", AppContext.getApiUrlSetting().getNanaLineClientId());
        params.put("clientSecret", AppContext.getApiUrlSetting().getNanaLineClientSecret());
        DigIwinCamResponse lineCamInfo = digIwinCamProxyService.getLineCamInfo(params);
        if (Objects.isNull(lineCamInfo)) {
            return url;
        }
        Map dataMap = JSONUtil.toBean(JSONUtil.toJsonStr(lineCamInfo.getData()), Map.class);
        return HttpUtil.urlWithForm(url, dataMap, CharsetUtil.CHARSET_UTF_8, true);
    }

    private Map<String, Object> queryLineCamInfo(ThirdPartyForParticipationRequestModel model) {
        try {
            if (StringUtils.isNotBlank(model.getCode())) {
                Map<String, Object> params = new HashMap(5);
                params.put("code", model.getCode());
                params.put("appId", "Athena");
                params.put("redirectUri", getNanaLineRedirectUri());
                params.put("clientId", AppContext.getApiUrlSetting().getNanaLineClientId());
                params.put("clientSecret", AppContext.getApiUrlSetting().getNanaLineClientSecret());
                DigIwinCamResponse lineCamInfo = digIwinCamProxyService.getLineCamInfo(params);
                if (Objects.nonNull(lineCamInfo)) {
                    return JSONUtil.parseObj(lineCamInfo.getData());
                }
            }
            return null;
        } catch (Exception e) {
            log.info("queryLineCamInfo is error");
            return null;
        }
    }
}
