package com.digiwin.mobile.mobileuibot.sso.utils;


import javax.servlet.http.HttpServletRequest;

/**
 * 根据当前请求的特征，判断该请求是否来自手机终端，主要检测特殊的头信息，以及user-Agent这个header
 *
 * @author yanfeng
 * @date 2023/10/18
 */
public class HttpRequestDeviceUtils {


    /**
     * @param request http请求
     * @return false pc  true mobile
     */
    public static boolean isMobileDevice(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && (userAgent.contains("Windows") || userAgent.contains("Macintosh"))) {
            // PC端访问
            return false;
        } else if (userAgent != null && userAgent.contains("Mobile")) {
            // 移动端访问
            return true;
        }
        return true;
    }

}

