package com.digiwin.mobile.mobileuibot.sysmanage;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>规则配置相关的API，用于管理规则配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleController
 * @Author: Zaregoto
 * @Date: 2022/9/13 10:57
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/rule")
public class RuleController {

    @Autowired
    private RuleService ruleService;

    /**
     * 找出sourceTenantId租户对应的规则，复制出来，然后将新增的规则的租户替换成targetTenantId
     *
     * @param sourceTenantId
     * @param targetTenantId
     * @param pathSchema
     * @Author: Liux
     * @Date: 2022/9/13 11点05分
     */
    @RequestMapping(value = "/addRule", method = RequestMethod.POST)
    public void copyRuleByTargetTenantId(String sourceTenantId, String targetTenantId, String pathSchema) {
        List<Rule> sourceRuleList = new ArrayList<>();
        List<Rule> targetRuleList = new ArrayList<>();
        //如果pathSchema有值则通过pathSchema和tenantId找到各自对应的规则，
        if (null != pathSchema && !pathSchema.isEmpty()) {
            //找到pathSchema对应的规则
            List<Rule> mobileRuleList = this.ruleService.findByRulePath(pathSchema);
            //过滤出租户是sourceTenantId的规则
            sourceRuleList = Rule.customMadeRules(sourceTenantId, mobileRuleList);
            //过滤出租户是targetTenantId的规则
            targetRuleList = Rule.customMadeRules(targetTenantId, mobileRuleList);
        } else {
            //找出租户是sourceTenantId值得所有规则
            sourceRuleList = this.ruleService.findByRuleTenantId(sourceTenantId);
            //找出租户是targetTenantId值得所有规则
            targetRuleList = this.ruleService.findByRuleTenantId(targetTenantId);
        }

        //循环更新目标租户规则，将其原有规则失效。
        for (Rule rule : targetRuleList) {
            this.ruleService.updateRule(rule);
        }

        List<Rule> newRuleList = new ArrayList<>();
        //循环替换规则中租户的值，改为targetTenantId值。放入到新的list中。
        for (Rule rule : sourceRuleList) {
            rule.setId(null);
            rule.setTenantId(targetTenantId);
            this.ruleService.insertRule(rule);
            newRuleList.add(rule);
        }
        //将新得到的规则list插入到规则表（mobileUiBotRule）中
//        this.ruleService.insertRuleList(newRuleList);

    }

}
