package com.digiwin.mobile.mobileuibot.sysmanage.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * <p>功能描述：缓存key的生成器,在使用了@Cacheable的方法时会用到</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CacheKeyGenerator
 * @Author: Zaregoto
 * @Date: 2022/7/3 22:15
 */
@Component("cacheKeyGenerator")
public class CacheKeyGenerator implements KeyGenerator {

    private static final Logger logger = LoggerFactory.getLogger(CacheKeyGenerator.class);

    public static final String KEY_DELIMITER = "_";

    @Override
    public Object generate(Object o, Method method, Object... objects) {
        String key = generateKey(method, objects);
        logger.debug("{} gain or generate key: {}", method, key);
        return key;
    }

    private static String generateKey(Method method, Object... params) {
        if ("getPccProjectProgressRateList".equals(method.getName())) {
            return generateGetPccProjectProgressRateListKey(params);
        }
        return "";
    }

    private static String generateGetPccProjectProgressRateListKey(Object... params) {
        StringBuilder key = new StringBuilder().append(getPccProjectProgressRateListKeyPrefix());
        for (int i = 0; i < params.length; i++) {
            // 不将第一个参数的语言别作为缓存的key
            if (i != 0) {
                key.append(KEY_DELIMITER).append(params[i]);
            }
        }
        return key.toString();
    }

    public static String getPccProjectProgressRateListKeyPrefix() {
        return "mobile-pccproject-progressrate";
    }
}
