package com.digiwin.mobile.mobileuibot.sysmanage.cache;

import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CacheServiceImpl
 * @Author: Zaregoto
 * @Date: 2022/7/3 22:09
 */
@Service("cacheService")
public class CacheServiceImpl implements CacheService {

    private static final Logger logger = LoggerFactory.getLogger(CacheServiceImpl.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private ProjectService projectService;

    @Override
    public Object refreshByKey(Object key) {
        if (key instanceof String) {
            String keyString = String.valueOf(key);
            if (keyString.startsWith(CacheKeyGenerator.getPccProjectProgressRateListKeyPrefix())) {
                logger.debug("refresh caches startsWith {}", CacheKeyGenerator.getPccProjectProgressRateListKeyPrefix());
                String[] params = keyString
                        .substring(CacheKeyGenerator.getPccProjectProgressRateListKeyPrefix().length()
                                + CacheKeyGenerator.KEY_DELIMITER.length())
                        .split(CacheKeyGenerator.KEY_DELIMITER);
                String locale = params[0];
                String iamUserToken = params[1];
                String tenantId = params[2];
                String projectId = params[3];
                // TODO 当前未配置生效
                return this.projectService.transCardDetailToPccProjectProgress(locale, iamUserToken, tenantId, projectId, false, "", "");
            }
        }
        return null;
    }
}