package com.digiwin.mobile.mobileuibot.sysmanage.logging;

import org.springframework.boot.actuate.logging.LoggersEndpoint;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.web.bind.annotation.*;

/**
 * 系统日志接口
 *
 * @author yanfeng
 * @date 2023/10/07
 */
@RestController
@RequestMapping(value = "/mobile/v1/log")
public class LoggingController {

    private final LoggingSystem loggingSystem = LoggingSystem.get(LoggingSystem.class.getClassLoader());


    @GetMapping("/getLevel")
    public Object getLevel(String name) {
        LoggerConfiguration configuration = loggingSystem.getLoggerConfiguration(name);
        return (configuration != null) ? new LoggersEndpoint.SingleLoggerLevels(configuration) : null;
    }

    @PostMapping("/updateLevel")
    public void updateLoggingLevel(@RequestParam("level") String level) {
        loggingSystem.setLogLevel("com.digiwin.mobile", LogLevel.valueOf(level));
    }

}
