package com.digiwin.mobile.mobileuibot.task.common;

import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：任务相关的数据抽取工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDataExtractUtil
 * @Author: Zaregoto
 * @Date: 2021/5/27 13:08
 */
public final class TaskDataExtractUtil {

    public static Map<String, Object> getSignoffProgressData(UiBotPageData pageData) {
        Map<String, Object> uiBotActivityData =
                (Map<String, Object>) pageData.get("uiBot__activity");
        Map<String, Object> uiBotActivityExtendedFieldsData =
                (Map<String, Object>) uiBotActivityData.get("extendedFields");
        Map<String, Object> uiBotActivityExtendedFieldsSignOffProgressData =
                (Map<String, Object>) uiBotActivityExtendedFieldsData.get("signOffProgressData");

        return uiBotActivityExtendedFieldsSignOffProgressData;
    }

    public static Map<String, Object> getWorkflowProgressRawData(UiBotPageData pageData) {
        Map<String, Object> uiBotActivityData = (Map<String, Object>) pageData.get("uiBot__activity");
        if (uiBotActivityData == null) {
            return null;
        }
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("workItemId", uiBotActivityData.get("workitemId"));
        rawData.put("serialNumber", uiBotActivityData.get("processSerialNumber"));
//        Map<String, Object> signoffProgressData = getSignoffProgressData(pageData);
//        if (signoffProgressData == null) {
//            return null;
//        }
//        List<Map<String, Object>> processInstances = (List<Map<String, Object>>) signoffProgressData.get("processInstances");
//        if (CollectionUtils.isEmpty(processInstances)) {
//            return null;
//        }
//        Map<String, Object> rawData = new HashMap<>();
//        rawData.put("workItemId", processInstances.get(0).get("workitemId"));
//        rawData.put("serialNumber", processInstances.get(0).get("processSerialNumber"));
//        rawData.put("tmActivityIds", processInstances.get(0).get("tmActivityIds"));
        return rawData;
    }

    //根据pageId获取相应默认数据
    public static Map<String, Object> getDefaultData(String pageId) {
        Map<String, Object> tabsColumnMap = new HashMap<>();
        String[] leftTitleFields;
        String rightTitleField;
        String[] contentFields;
        int contentFieldsLimit;
        Map<String, String> valueToTextMap;
        String[] fieldArray;
        switch (PageSettingIdPresetEnum.getEnumByName(pageId)) {
            case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST:
            case MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST:
                leftTitleFields = new String[]{"op_name"};
                rightTitleField = "production_status";
                contentFields = new String[]{
                        "wo_no", "production_status", "sub_op_name", "check_in_datetime"
                };
                contentFieldsLimit = 6;
                valueToTextMap = new HashMap<>();
                valueToTextMap.put("production_status_1", "未开始");
                valueToTextMap.put("production_status_2", "进行中");
                valueToTextMap.put("production_status_3", "已完成");
                valueToTextMap.put("production_status_4", "异常");
                valueToTextMap.put("wo_no", "制令号码");
                valueToTextMap.put("production_status", "制令状态");
                valueToTextMap.put("item_no", "产品编号");
                valueToTextMap.put("item_name", "产品名称");
                valueToTextMap.put("sub_op_name", "子制程名");
                valueToTextMap.put("check_in_datetime", "上线时间");

                tabsColumnMap.put("leftTitleFields", leftTitleFields);
                tabsColumnMap.put("rightTitleField", rightTitleField);
                tabsColumnMap.put("contentFields", contentFields);
                tabsColumnMap.put("contentFieldsLimit", contentFieldsLimit);
                tabsColumnMap.put("valueToTextMap", valueToTextMap);
                break;
            case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_DETAIL:
                leftTitleFields = new String[]{"sub_op_name"};
                rightTitleField = "";
                contentFields = new String[]{
                        "check_in_datetime"
                };
                valueToTextMap = new HashMap<>();
                //TODO 下面是为了演示用，后续需要修改成国际化
                valueToTextMap.put("production_status_1", "未开始");
                valueToTextMap.put("production_status_2", "进行中");
                valueToTextMap.put("production_status_3", "已完成");
                valueToTextMap.put("production_status_4", "异常");
                valueToTextMap.put("production_status", "制程状态");
                valueToTextMap.put("wo_no", "制令单号");
                valueToTextMap.put("item_no", "产品品号");
                valueToTextMap.put("item_name", "产品品名");
                valueToTextMap.put("check_in_datetime", "上线时间");

                tabsColumnMap.put("leftTitleFields", leftTitleFields);
                tabsColumnMap.put("rightTitleField", rightTitleField);
                tabsColumnMap.put("contentFields", contentFields);
                tabsColumnMap.put("valueToTextMap", valueToTextMap);
                break;
            case MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST:
                leftTitleFields = new String[]{"op_name"};
                rightTitleField = "production_status";
                contentFields = new String[]{
                        "progress_percentage", "remaining_qty", "standard_work_hours","total_work_hours",
                        "merge_no", "plan_start_date", "plan_complete_date"
                };
                contentFieldsLimit = 5;
                valueToTextMap = new HashMap<>();
                valueToTextMap.put("production_status_1", "未开始");
                valueToTextMap.put("production_status_2", "进行中");
                valueToTextMap.put("production_status_3", "已完成");
                valueToTextMap.put("production_status_4", "异常");
                valueToTextMap.put("progress_percentage", "进度百分比");
                valueToTextMap.put("remaining_qty", "待出站量");
                valueToTextMap.put("standard_work_hours", "标准工时");
                valueToTextMap.put("total_work_hours", "实际工时");
                valueToTextMap.put("merge_no", "合并单号");
                valueToTextMap.put("plan_start_date", "预计开工日期");
                valueToTextMap.put("plan_complete_date", "预计完工日期");

                tabsColumnMap.put("leftTitleFields", leftTitleFields);
                tabsColumnMap.put("rightTitleField", rightTitleField);
                tabsColumnMap.put("contentFields", contentFields);
                tabsColumnMap.put("contentFieldsLimit", contentFieldsLimit);
                tabsColumnMap.put("valueToTextMap", valueToTextMap);
                break;
            default:
                break;
        }
        return tabsColumnMap;
    }
}
