package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;

/**
 * <p>功能描述：任务过滤设置项类型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterSettingCategoryEnum
 * @Author: Zaregoto
 * @Date: 2021/11/20 19:03
 */
public enum TaskFilterCategoryEnum {
    /**
     * 根据标准Pattern设置
     */
    PATTERN("pattern"),

    /**
     * 根据项目信息设置
     */
    PROJECT("project"),

    /**
     * 根据任务信息设置
     */
    TASK("task")
    ;

    private String value;

    TaskFilterCategoryEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static TaskFilterCategoryEnum getEnumByName(String name) {
        String tester = name;
        for (TaskFilterCategoryEnum taskFilterCategoryEnum :
            TaskFilterCategoryEnum.values()) {
            if (taskFilterCategoryEnum.name().equalsIgnoreCase(tester)) {
                return taskFilterCategoryEnum;
            }
        }
        return null;
    }
}
