package com.digiwin.mobile.mobileuibot.task.filter;

import lombok.Getter;

/**
 * <p>功能描述：任务过滤参数匹配枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterMatchEnum.java
 * @Author: wangjwc
 * @Date: created at 2023/11/2 11:55
 */
@Getter
public enum TaskFilterMatchEnum {
    /**
     * 精确匹配
     */
    EQUALS("equals"),
    /**
     * 前缀匹配
     */
    PREFIX("prefix"),
    /**
     * 后缀匹配
     */
    SUFFIX("suffix"),
    /**
     * 包含匹配
     */
    CONTAIN("contain"),

    ;

    private final String value;

    TaskFilterMatchEnum(String value) {
        this.value = value;
    }

    public static TaskFilterMatchEnum getEnumByValue(String value) {
        for (TaskFilterMatchEnum matchEnum : TaskFilterMatchEnum.values()) {
            if (matchEnum.getValue().equalsIgnoreCase(value)) {
                return matchEnum;
            }
        }
        return null;
    }
}
