package com.digiwin.mobile.mobileuibot.task.filter;

import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：任务过滤中的参数实体类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterParam.java
 * @Author: wangjwc
 * @Date: created at 2023/11/2 13:05
 */
@Data
public class TaskFilterParam implements Serializable {
    private static final long serialVersionUID = 4160327934578040557L;
    private String tmPattern;
    private String tmCategory;
    private String tmTaskId;
    private String tmActivityId;

    /**
     * @see TaskFilterMatchEnum
     * 如果没值，则默认精确匹配
     */
//    // 现有场景tmPattern只存在精确匹配，不存在其它匹配模式
//    private String tmPatternMatch;
//    // 现有场景tmCategory只存在精确匹配，不存在其它匹配模式
//    private String tmCategoryMatch;
    // 现有场景tmTaskId只存在精确匹配，不存在其它匹配模式
    private String tmTaskIdMatch;
    // 存在其它匹配模式 TaskFilterMatchEnum
    private String tmActivityIdMatch;
}
