package com.digiwin.mobile.mobileuibot.task.filter;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 * 参考链接：https://docs.spring.io/spring-data/data-document/docs/current/reference/html/#repositories.custom-implementations
 *
 * @FileName: TaskFilterSettingRepositoryCustom
 * @Author: Zaregoto
 * @Date: 2021/11/21 18:21
 */
public interface TaskFilterRepositoryCustom {

    /**
     * 通过使用缓存，找到在Athena中有效的TaskFilter集合
     *
     * @return
     */
    List<TaskFilter> listValidInAthena(String version);

//    /**
//     * 选择数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    TaskFilter selectByDesigner(String tmActivityId);
//
//    /**
//     * 删除数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    List<TaskFilter> deleteByDesigner(String tmActivityId);
//
//    /**
//     * 插入数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    void insertByDesigner(String tmActivityId);

    /**
     * 通过appCode和version删除数据
     *
     * @param appCode 应用代号
     * @param version 数据版本
     */
    void deleteByCode(String appCode, String version);

    /**
     * 通过appCode和version查询数据
     *
     * @param appCode 应用代号
     * @param version 数据版本
     */
    List<TaskFilter> selectByCode(String appCode, String version);

    /**
     * 批量插入数据
     *
     * @param taskFilters 需要插入的数据
     * @param version 数据版本
     */
    void batchInsert(List<TaskFilter> taskFilters, String version);
}
