package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterSettingRepositoryImpl
 * @Author: Zaregoto
 * @Date: 2021/11/21 18:22
 */
public class TaskFilterRepositoryImpl implements TaskFilterRepositoryCustom {

    private static final Logger logger = LoggerFactory.getLogger(TaskFilterRepositoryImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

    @Override
    @Cacheable(cacheNames = "taskFilterList", cacheManager = "systemCacheManager", key = "#root.targetClass.simpleName + ':' + #version")
    public List<TaskFilter> listValidInAthena(String version) {
        logger.debug("cache miss in list taskFilters...invoke find by source and valid property...");
        Query query = new Query();
        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
                .addCriteria(Criteria.where("valid").is(true))
                .addCriteria(Criteria.where("version").is(version));

        // 查到所有有效任务过滤配置后，再过滤出当前启动环境下有效的配置
        return this.mongoTemplate.find(query, TaskFilter.class)
                .stream().filter(filter -> filter.validWithAppEnvType(AppContext.getEnvType()))
                .collect(Collectors.toList());
    }

//    @Override
//    public TaskFilter selectByDesigner(String tmActivityId) {
//        Query query = new Query();
//        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
//                .addCriteria(Criteria.where("category").is(TaskFilterCategoryEnum.TASK.getValue()))
//                .addCriteria(Criteria.where("param.tmActivityId").is(tmActivityId))

    ////                .addCriteria(Criteria.where("valid").is(true))
//                .addCriteria(Criteria.where("from").is(TaskFilterFromEnum.DESIGNER.getValue()));
//        return mongoTemplate.findOne(query, TaskFilter.class);
//    }
//
//    @Override
//    @CacheEvict(cacheNames = "taskFilterList", cacheManager = "systemCacheManager", key = "#root.targetClass.simpleName")
//    public List<TaskFilter> deleteByDesigner(String tmActivityId) {
//        Query query = new Query();
//        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
//                .addCriteria(Criteria.where("category").is(TaskFilterCategoryEnum.TASK.getValue()))
//                .addCriteria(Criteria.where("param.tmActivityId").is(tmActivityId))
//                .addCriteria(Criteria.where("valid").is(true))
//                .addCriteria(Criteria.where("from").is(TaskFilterFromEnum.DESIGNER.getValue()));
//        return mongoTemplate.findAllAndRemove(query, TaskFilter.class);
//    }
//
//    @Override
//    @CacheEvict(cacheNames = "taskFilterList", cacheManager = "systemCacheManager", key = "#root.targetClass.simpleName")
//    public void insertByDesigner(String tmActivityId) {
//        if (null != this.selectByDesigner(tmActivityId)) {
//            return;
//        }
//        TaskFilter taskFilter = new TaskFilter();
//        taskFilter.setSource(StringUtil.SOURCE_ATHENA);
//        taskFilter.setCategory(TaskFilterCategoryEnum.TASK.getValue());
//        TaskFilterParam param = new TaskFilterParam();
//        param.setTmActivityId(tmActivityId);
//        taskFilter.setParam(param);
//        taskFilter.setParamOp("==");
//        taskFilter.setValid(true);
//        List<EnvScope> list = new ArrayList<>();
//        EnvScope prod = new EnvScope();
//        prod.setType(AppEnvTypeEnum.PRODUCTION.getEnvType());
//        prod.setValid(false);
//        list.add(prod);
//        EnvScope test = new EnvScope();
//        test.setType(AppEnvTypeEnum.TEST.getEnvType());
//        test.setValid(true);
//        list.add(test);
//        EnvScope dev = new EnvScope();
//        dev.setType(AppEnvTypeEnum.DEVELOP.getEnvType());
//        dev.setValid(true);
//        list.add(dev);
//        taskFilter.setEnvScopes(list);
//        taskFilter.setFrom(TaskFilterFromEnum.DESIGNER.getValue());
//        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
//        taskFilter.setCreateTime(time);
//        taskFilter.setUpdateTime(time);
//        this.mongoTemplate.insert(taskFilter);
//    }
    @Override
    @CacheEvict(cacheNames = "taskFilterList", cacheManager = "systemCacheManager", key = "#root.targetClass.simpleName + ':' + #version")
    public void deleteByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("version").is(version));
        // AB库同时操作
        mongoTemplate.findAllAndRemove(query, TaskFilter.class);
        secondMongoTemplate.findAllAndRemove(query, TaskFilter.class);
    }

    @Override
    public List<TaskFilter> selectByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("version").is(version));
        List<TaskFilter> list = mongoTemplate.find(query, TaskFilter.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }

    @Override
    @CacheEvict(cacheNames = "taskFilterList", cacheManager = "systemCacheManager", key = "#root.targetClass.simpleName + ':' + #version")
    public void batchInsert(List<TaskFilter> taskFilters, String version) {
        if (CollectionUtils.isEmpty(taskFilters)) {
            return;
        }
        // AB库同时操作
        mongoTemplate.insertAll(taskFilters);
        secondMongoTemplate.insertAll(taskFilters);
    }
}
