package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;

import java.util.List;

/**
 * <p>功能描述：任务过滤服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterService
 * @Author: Zaregoto
 * @Date: 2021/11/21 17:45
 */
public interface TaskFilterService {

    /**
     * 根据鼎捷ATMC的任务，判断出是否支持在移动端呈现
     * <p>
     * <p>
     * FIXME
     * 2021年5月迭代只有签核型任务，所以只过滤得到那些任务
     * 2021年6月迭代增加回报型任务
     * 2021年7月，因Beta客户只先使用项目中控台，没有签核型任务，且项目中控台的签核型任务还有录入，我们暂时不支持，所以最终
     * 生产环境下，只返回回报型任务
     * 2021年7月27日，支持SSC的员工入职办理任务，增加对tmActivityId内容的判断处理
     *
     * @param digiwinAtmcBacklog
     * @return true-支持，false-不支持
     */
    boolean isSupportedTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog, List<TaskFilter> filterList);

    boolean isSupportedTaskByDigiwinAtmcBacklogDetail(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<TaskFilter> filterList);

    boolean isSupportedTaskByDigiwinAtmcTask(DigiwinAtmcTask digiwinAtmcTask, List<TaskFilter> filterList);

    /**
     * 过滤出只是行事历发起的任务卡
     *
     * @param digiwinAtmcBacklog
     * @return
     */
    boolean isCanlderTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog);


//    /**
//     * 选择数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    TaskFilter selectByDesigner(String tmActivityId);
//
//    /**
//     * 删除数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    void deleteByDesigner(String tmActivityId);
//
//    /**
//     * 插入数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    void insertByDesigner(String tmActivityId);
}
