package com.digiwin.mobile.mobileuibot.task.filter;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskFilterServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/11/21 17:46
 */
@Service("taskFilterService")
public class TaskFilterServiceImpl implements TaskFilterService {

    private static final Logger logger = LoggerFactory.getLogger(TaskFilterServiceImpl.class);

    @Autowired
    private TaskFilterRepository taskFilterRepository;

    @Override
    public boolean isSupportedTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog, List<TaskFilter> filterList) {
//        List<TaskFilter> filterList = this.taskFilterRepository.listValidInAthena();
        boolean filterCalculateResult = this.calculateFilterResult(filterList, digiwinAtmcBacklog);

        // 任务类型
        boolean backlogtypeSupported = digiwinAtmcBacklog.getBacklogtypeSupported();

        return filterCalculateResult && backlogtypeSupported;
    }

    @Override
    public boolean isSupportedTaskByDigiwinAtmcBacklogDetail(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<TaskFilter> filterList) {
        DigiwinAtmcBacklog backlog = new DigiwinAtmcBacklog();
        backlog.setTmPattern(digiwinAtmcBacklogDetail.getTmPattern());
        backlog.setTmCategory(digiwinAtmcBacklogDetail.getTmCategory());
        backlog.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
        // FIXME 这里是假设类型为正常，但其实无法从消息中拿到。需要之后验证数据情况
        backlog.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue());
        return this.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList);
    }

    @Override
    public boolean isSupportedTaskByDigiwinAtmcTask(DigiwinAtmcTask digiwinAtmcTask, List<TaskFilter> filterList) {
        DigiwinAtmcBacklog backlog = new DigiwinAtmcBacklog();
        backlog.setTmPattern(digiwinAtmcTask.getTmPattern());
        backlog.setTmCategory(digiwinAtmcTask.getTmCategory());
        backlog.setTmTaskId(digiwinAtmcTask.getTmTaskId());
        // FIXME 这里是假设类型为正常，但其实无法从消息中拿到。需要之后验证数据情况
        backlog.setType(DigiwinAtmcBacklogTypeEnum.NORMAL.getValue());
        return this.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList);
    }

    @Override
    public boolean isCanlderTaskByDigiwinAtmcBacklog(DigiwinAtmcBacklog digiwinAtmcBacklog) {
        return digiwinAtmcBacklog.getType().equals(DigiwinAtmcBacklogTypeEnum.CALENDAR.getValue()) || digiwinAtmcBacklog.getType().equals(DigiwinAtmcBacklogTypeEnum.TEAM_CALENDAR.getValue());
    }

    private boolean calculateFilterResult(final List<TaskFilter> taskFilterList, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        List<TaskFilter> equalFilterList = taskFilterList.stream().filter(
                taskFilter -> TaskFilterParamOpEnum.EQUALS.getValue().equals(taskFilter.getParamOp())
        ).collect(Collectors.toList());

        List<TaskFilter> noEqualFilterList = taskFilterList.stream().filter(
                taskFilter -> TaskFilterParamOpEnum.NOT_EQUALS.getValue().equals(taskFilter.getParamOp())
        ).collect(Collectors.toList());

        return this.matchWithFilter(equalFilterList, digiwinAtmcBacklog)
                && !this.matchWithFilter(noEqualFilterList, digiwinAtmcBacklog);
    }

    private boolean matchWithFilter(final List<TaskFilter> taskFilterList, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        return taskFilterList.stream()
                .anyMatch(taskFilter -> {
                    boolean isMatch = false;
                    TaskFilterCategoryEnum categoryEnum = TaskFilterCategoryEnum.getEnumByName(taskFilter.getCategory());
                    if (null == categoryEnum) {
                        return isMatch;
                    }
                    switch (categoryEnum) {
                        case PATTERN:
                            isMatch = taskFilter.matchInPatternAndCategory(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory());
                            break;
                        case PROJECT:
                            isMatch = taskFilter.matchInTaskId(digiwinAtmcBacklog.getTmTaskId());
                            break;
                        case TASK:
                            isMatch = taskFilter.matchInTaskIdAndActivityId(digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId());
                            break;
                        default:
                            break;
                    }
                    return isMatch;
                });
    }

//
//    @Override
//    public TaskFilter selectByDesigner(String tmActivityId) {
//        return taskFilterRepository.selectByDesigner(tmActivityId);
//    }
//
//    @Override
//    public void deleteByDesigner(String tmActivityId) {
//        taskFilterRepository.deleteByDesigner(tmActivityId);
//    }
//
//    @Override
//    public void insertByDesigner(String tmActivityId) {
//        taskFilterRepository.insertByDesigner(tmActivityId);
//    }
}
