package com.digiwin.mobile.mobileuibot.task.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.ocr.InputOcr;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleInitConfig;
import com.digiwin.mobile.mobileuibot.core.rule.RuleScopeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：任务详情数据模型的抽象类，提供了一些通用的方法</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbstractTaskDetail
 * @Author: Zaregoto
 * @Date: 2021/10/15 10:38
 */
public abstract class AbstractTaskDetail extends LinkedHashMap<String, MobileComponent>
        implements TaskDetail {

    private static final long serialVersionUID = -8428314755038635277L;
    private LocaleService localeService;

    public AbstractTaskDetail() {

    }

    public AbstractTaskDetail(LocaleService localeService) {
        this.localeService = localeService;
    }

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private List<UiBotLayout> actualLayoutList = new ArrayList<>();

    public List<UiBotLayout> getActualLayoutList() {
        return actualLayoutList;
    }

    public void setActualLayoutList(List<UiBotLayout> actualLayoutList) {
        this.actualLayoutList = actualLayoutList;
    }

    /**
     * 在实际layout列表尾部追加一个layout对象
     *
     * @param actualLayout
     */
    public void addActualLayout(UiBotLayout actualLayout) {
        this.getActualLayoutList().add(actualLayout);
    }

    /**
     * 在实际layout列表的指定索引位置增加一个layout对象
     *
     * @param index        增加位置的索引。从0开始。
     * @param actualLayout
     */
    public void addActualLayout(int index, UiBotLayout actualLayout) {
        this.getActualLayoutList().add(index, actualLayout);
    }

    /**
     * 在实际layout列表的指定索引位置增加一批layout对象
     *
     * @param index            增加位置的索引。从0开始。
     * @param actualLayoutList
     */
    public void addActualLayout(int index, List<UiBotLayout> actualLayoutList) {
        this.getActualLayoutList().addAll(index, actualLayoutList);
    }

    /**
     * 根据栏位Tag，判断是否跳过当前栏位的处理
     *
     * @param columnTag
     * @return true-跳过不处理，不对当前栏位生成控件；false-不跳过，按正常逻辑生成控件
     */
    protected abstract Boolean skipCurrentColumn(ColumnTag columnTag);

    /**
     * 在实际layout列表尾部增加一个移动端组件对象，并使用[组件名称_UUID]作为schema
     *
     * @param mobileComponent 移动端组件对象
     */
    public void addMobileComponent(MobileComponent mobileComponent) {
        int tailIndex = this.getActualLayoutList().size();
        this.addMobileComponent(tailIndex, mobileComponent.returnComponentType() + "_" + UUIDUtil.getUuid(), mobileComponent);
    }

    /**
     * 在实际layout列表尾部增加一个移动端组件对象，并使用传入的componentSchema作为schema
     *
     * @param componentSchema 移动端组件在页面数据中的key
     * @param mobileComponent 移动端组件对象
     */
    public void addMobileComponent(String componentSchema, MobileComponent mobileComponent) {
        int tailIndex = this.getActualLayoutList().size();
        this.addMobileComponent(tailIndex, componentSchema, mobileComponent);
    }

    /**
     * 在实际layout列表的指定索引位置增加一个移动端组件对象，并使用[组件名称_UUID]作为schema
     *
     * @param index           增加位置的索引。从0开始。
     * @param mobileComponent 移动端组件对象
     */
    public void addMobileComponent(int index, MobileComponent mobileComponent) {
        this.addMobileComponent(index, mobileComponent.returnComponentType() + "_" + UUIDUtil.getUuid(), mobileComponent);
    }

    /**
     * 在实际layout列表的指定索引位置增加一个移动端组件对象，并使用传入的componentSchema作为schema
     *
     * @param index           增加位置的索引。从0开始。
     * @param componentSchema 移动端组件在页面数据中的key
     * @param mobileComponent 移动端组件对象
     */
    public void addMobileComponent(int index, String componentSchema, MobileComponent mobileComponent) {
        // 增加到实际layout列表内
        UiBotLayout layout = new UiBotLayout();
        layout.setType(mobileComponent.returnComponentType());
        layout.setSchema(componentSchema);
        this.addActualLayout(index, layout);
        // 增加到实际页面数据内
        this.put(componentSchema, mobileComponent);
    }

    public void addMobileComponentsByColumnAndBizData(String locale, List<UiBotTableColumn> columnList,
                                                      UiBotModel pcUibotModel, Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                                      List<Rule> mobileRuleList, List<ColumnTag> columnTagList, ApiRequest apiRequest) {
        // 是否团队任务。若是，则所有字段只读处理，无论是否有自定义的INIT类型规则配置;同时清空所有字段在录入时用到的规则设置
        boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
        List<UiBotRule> uiBotRuleList = pcUibotModel.getRules();
        if (taskInReadOnlyMode) {
            uiBotRuleList = Collections.emptyList();
            mobileRuleList = Collections.emptyList();
        }

        // 将MobileRuleList转换为Map，节省在生成组件的循环中循环全部MobileRuleList的时间
        Map<String, List<Rule>> mobileRuleGroupedMap =
                mobileRuleList.stream().collect(Collectors.groupingBy(Rule::getSchema));

        UiBotTableColumn prevColumn = null;
        for (UiBotTableColumn column : columnList) {

            ColumnTag columnTag = columnTagList.stream()
                    .filter(ct -> ct.getSchema().equalsIgnoreCase(column.getSchema()))
                    .findFirst().orElse(null);

            // add by mowj 20211015 for DetailItemDetail
            if (skipCurrentColumn(columnTag)) {
                continue;
            }

            // 针对由手动配置的字段规则影响字段初始可读属性的处理，方便计算分割线
            if (mobileRuleGroupedMap.containsKey(column.getSchema())) {
                List<Rule> initRule = mobileRuleGroupedMap.get(column.getSchema())
                        .stream().filter(r ->
                                RuleScopeEnum.INIT.getScope().equalsIgnoreCase(r.getScope())
                                        && null != r.getInitConfig()).collect(Collectors.toList());

                //判断是否走客制规则
                if (Rule.hasCustomMadeRule(apiRequest, initRule)) {
                    initRule = Rule.compareRule(apiRequest, initRule, RuleScopeEnum.INIT.getScope());
                }

                initRule.forEach(rule -> {
                    if (rule.validWithBizData(bizData)) {
                        String componentType =
                                Optional.ofNullable(rule.getInitConfig())
                                        .map(RuleInitConfig::getComponentType).orElse(Field.COMPONENT_TYPE);
                        // 初始化范围内字段是否可编辑。数据库没配置时为null，不处理
                        Boolean initScopeEnable = Optional.ofNullable(rule.getInitConfig())
                                .map(RuleInitConfig::getEnable).orElse(null);
                        // 初始化范围内字段是否必填。数据库没配置时为null，不处理
                        Boolean initScopeRequired = Optional.ofNullable(rule.getInitConfig())
                                .map(RuleInitConfig::getRequired).orElse(null);
//                                switch (componentType) {
//                                    case InputCalendar.COMPONENT_TYPE:
//                                        if (!column.canEdit()) {
//                                            column.doSetCanEdit();
//                                        }
//                                        break;
//                                    case Field.COMPONENT_TYPE:
//                                    default:
//                                        // 修改PC UIBot的栏位数据成不可编辑的状态，方便在计算分割线组件时判断是否只读
//                                        if (column.canEdit()) {
//                                            column.doSetCanNotEdit();
//                                        }
//                                        break;
//                                }
                        /**
                         * 有配置过并且不在只读模式时，才处理自定义的初始化规则
                         */
                        if (null != initScopeEnable && !taskInReadOnlyMode) {
                            if (initScopeEnable && column.canEdit()) {
                                // 配置与实际栏位编辑状态一致，不需处理
                            } else if (initScopeEnable && !column.canEdit()) {
                                column.doSetCanEdit();
                            } else if (!initScopeEnable && column.canEdit()) {
                                column.doSetCanNotEdit();
                            } else {
                                // 配置与实际栏位编辑状态一致，不需处理
                            }
                        }
                        if (null != initScopeRequired && !taskInReadOnlyMode) {
                            // 设置是否必填
                            column.setMRequired(initScopeRequired);
                        }
                    }
                });
            }

            // 过滤出PC端Rule中针对本栏位的规则，不包含其他栏位
            List<UiBotRule> ruleForCurrentColumnSelfOnly = uiBotRuleList.stream()
                    .filter
                            (uiBotRule ->
                                    (null != uiBotRule.getSchema() &&
                                            uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) &&
                                            null == uiBotRule.getTargetSchema()
                                            && "pattern".equalsIgnoreCase(uiBotRule.getKey())
                                    )
                                            || (null != uiBotRule.getTargetSchema() &&
                                            uiBotRule.getTargetSchema().equalsIgnoreCase(column.getSchema())
                                    )
                                            || (null != uiBotRule.getSchema() &&
                                            uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) &&
                                            "required".equalsIgnoreCase(uiBotRule.getKey())
                                    )
                                            || (null != uiBotRule.getSchema() &&
                                            uiBotRule.getSchema().equalsIgnoreCase(column.getSchema()) &&
                                            "maxLength".equalsIgnoreCase(uiBotRule.getKey())
                                    )
                            )
                    .collect(Collectors.toList());

            this.calculateComponent(locale, column, ruleForCurrentColumnSelfOnly, bizData,
                    digiwinAtmcBacklogDetail, mobileRuleList, mobileRuleGroupedMap, columnTag, apiRequest, pcUibotModel.getVariableMaps());

            prevColumn = column;
        }
    }

    protected void calculateComponent(String locale, UiBotTableColumn column,
                                      List<UiBotRule> columnRuleList, Map<String, Object> bizData,
                                      DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                      List<Rule> mobileRuleList, Map<String, List<Rule>> mobileRuleGroupedMap,
                                      ColumnTag columnTag, ApiRequest apiRequest, Map<String, Object> variableMaps) {
        String bizDataSchema = column.getSchema();
        Assert.notNull(bizDataSchema, "bizDataSchema must not null in building process!");
        String dataType = Optional.ofNullable(column.getDataType()).orElse("");
        String type = Optional.ofNullable(column.getType()).orElse("");

        MobileComponent mobileComponent = null;
        if ("string".equalsIgnoreCase(dataType) && !type.toUpperCase().contains("UPLOAD")) {
            if (column.canEdit()) {
                if (null != columnTag && columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_LONGTEXT.getCode())) {
                    String errorMessage = localeService.getLanguageValue(locale, "任务已逾期，报工说明必填！");
                    mobileComponent = InputMultiText.create(locale, column, columnRuleList, bizData,
                            mobileRuleList, false,
                            Optional.ofNullable(column).map(UiBotTableColumn::getMaxLength).orElse(-1),
                            variableMaps, errorMessage);
                } else {
                    mobileComponent =
                            InputSingleText.create(locale, column, columnRuleList, bizData,
                                    mobileRuleList);

                }
                this.put(bizDataSchema, mobileComponent);
            } else {
                String value = column.getValueForDisplay(bizData);
                // 只读的话，空值，移动不显示
                if (!value.trim().isEmpty()) {
                    if (null != columnTag && columnTag.getTagDefinition().getCode()
                            .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_LONGTEXT.getCode())) {
                        mobileComponent = TextMulti.create(column, value, locale);
                    } else {
                        Field field = Field.create(column, value);
                        field.setLabelStyleType(2);
                        mobileComponent = field;
                    }
                    this.put(bizDataSchema, mobileComponent);
                }
            }
        } else if ("date".equalsIgnoreCase(dataType) && "DATEPICKER".equalsIgnoreCase(type)) {
//            // TODO 需要让所有类型组件的生成逻辑都支持以下scope=INIT规则的处理，最终实现应用定制生成逻辑与平台标准生成逻辑的分离
//            Optional<Rule> currentSchemaInitMobileRule =
//                    mobileRuleGroupedMap.get(column.getSchema())
//                            .stream().filter(r ->
//                                    RuleScopeEnum.INIT.getScope().equalsIgnoreCase(r.getScope())
//                                            && null != r.getInitConfig())
//                            .findFirst();
//
//            if (currentSchemaInitMobileRule.isPresent()
//                    && currentSchemaInitMobileRule.get().validWithBizData(bizData)) {
//                Rule rule = currentSchemaInitMobileRule.get();
//                // TODO 使用组件生成工厂来统一调用入口，目前仅支持FIELD、INPUT_CALENDAR组件
//                // 依据初始化规则的配置参数，初始化当前字段的生成内容
//                String componentType = Optional.ofNullable(rule.getInitConfig())
//                        .map(RuleInitConfig::getComponentType).orElse(Field.COMPONENT_TYPE);
//                boolean enable = Optional.ofNullable(rule.getInitConfig())
//                        .map(RuleInitConfig::getEnable).orElse(true);
//                switch (componentType) {
//                    case InputCalendar.COMPONENT_TYPE:
//                        mobileComponent =
//                                InputCalendar.create(locale, column, columnRuleList, bizData, mobileRuleList, enable);
//                        this.put(bizDataSchema, mobileComponent);
//                        break;
//                    case Field.COMPONENT_TYPE:
//                    default:
//                        String value = column.getValueForDisplay(bizData);
//                        // 只读的话，空值，移动不显示
//                        if (!value.trim().isEmpty()) {
//                            mobileComponent = Field.create(column, value);
//                            this.put(column.getSchema(), mobileComponent);
//                        }
//                        break;
//                }
//            } else {
            /***
             * modify by mowj 20220819
             * 日历录入组件支持用enable字段控制是否可用（只读或编辑），故修改原有代码不再使用Field组件生成。
             * 一是可以保证组件会存在于画面上，
             * 二是可以保证前端联动规则可以正常运行（动态改变它的只读或编辑状态）
             */

            mobileComponent =
                    InputCalendar.create(locale, column, columnRuleList, bizData, mobileRuleList, true,
                            Optional.ofNullable(column).map(UiBotTableColumn::getMRequired).orElse(false), apiRequest);
            if (column.canEdit()) {
                ((InputCalendar) mobileComponent).setEnable(true);
            } else {
                ((InputCalendar) mobileComponent).setEnable(false);
            }
            this.put(bizDataSchema, mobileComponent);
//            }
        } else if ("numeric".equalsIgnoreCase(dataType)) {
            /***
             * mark by mowj 20220814
             * 因202208迭代18的需求，遇到PCC应用的“完成率”字段须为只读，但仍要保证值校验、错误提示等功能。
             * 考虑通用性，故从字段的数值类型判断，修改移动端组件的生成逻辑，不再使用Field组件。
             *   且为了前端控制方便，也不因为字段值为空而不显示它。
             */
//            if (column.canEdit()) {
//                mobileComponent =
//                        InputNumeric.create(locale, column, columnRuleList, bizData, mobileRuleList);
//                this.put(bizDataSchema, mobileComponent);
//            } else {
//                String value = column.getValueForDisplay(bizData);
//                // 只读的话，空值，移动不显示
//                if (!value.trim().isEmpty()) {
//                    mobileComponent = Field.create(column, value);
//                    this.put(column.getSchema(), mobileComponent);
//                }
//            }
            mobileComponent = InputNumeric.create(locale, column, columnRuleList, bizData,
                    mobileRuleList, apiRequest, variableMaps, localeService);
            if (column.canEdit()) {
                ((InputNumeric) mobileComponent).setEnable(true);
            } else {
                ((InputNumeric) mobileComponent).setEnable(false);
            }
            this.put(bizDataSchema, mobileComponent);
        } else if (type.equalsIgnoreCase("TEXTAREA_TEXT") || PcModuleEnum.TEXTAREA.getValue().equalsIgnoreCase(type)) {
            if (column.canEdit()) {
                String errorMessage = localeService.getLanguageValue(locale, "任务已逾期，报工说明必填！");
                mobileComponent = InputMultiText.create(locale, column, columnRuleList, bizData,
                        mobileRuleList, false,
                        Optional.ofNullable(column).map(UiBotTableColumn::getMaxLength).orElse(-1),
                        Collections.emptyMap(), errorMessage);
                this.put(bizDataSchema, mobileComponent);
            } else {
                String value = column.getValueForDisplay(bizData);
                // 只读的话，空值，移动不显示
                if (!value.trim().isEmpty()) {
                    mobileComponent = TextMulti.create(column, value, locale);
                    this.put(bizDataSchema, mobileComponent);
                }
            }
        } else if (TaskStringUtil.CUSTOM_TASK_CODE_CLOUD_STEWARD_REPORT.equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId()) && ("sch-manual-task-delivery".equalsIgnoreCase(type) || "sch-manual-task-delivery-history".equalsIgnoreCase(type))) {
            //体系云手动报工: 由于应用交付物和历史交付物定制,固有此处代码
            mobileComponent = Attachment.createManualReportingAttachment(locale, column, bizData, digiwinAtmcBacklogDetail);
            this.put(bizDataSchema, mobileComponent);
        } else if (type.toUpperCase().contains("UPLOAD") || type.toUpperCase().contains("FILE_UPLOAD")) {
            // 体系云管家附件日期展示
            if (TaskStringUtil.CUSTOM_TASK_CODE_CLOUD_STEWARD_REPORT.equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId())
                    && "delivery_attachment".equalsIgnoreCase(column.getSchema())) {
                Object data = bizData.get(column.getSchema());
                Attachment.translateDoubleTimeToString(data, "create_date");
            }

            // 判断是否只上传图片.for 客制应用名：员工共享服务中心，简称：SSC。任务内容：入职办理任务
            List<String> supportFileExtensions = Optional.ofNullable(column.getAttribute())
                    .map(UiBotTableAttachmentColumnAttribute::getFileExtensions)
                    .orElse(Collections.emptyList());
            boolean isOnlyForPicture = supportFileExtensions != null && !supportFileExtensions.isEmpty()
                    && (
                    supportFileExtensions.get(0).toLowerCase().contains("png")
                            || supportFileExtensions.get(0).toLowerCase().contains("jpg"));
            // 判断是否关闭aam同步
            boolean disableAam = Optional.ofNullable(column.getAttribute())
                    .map(UiBotTableAttachmentColumnAttribute::getDisableAam)
                    .orElse(false);
            if (isOnlyForPicture) {
                mobileComponent = Picture.create(locale, column, columnRuleList, bizData,
                        digiwinAtmcBacklogDetail, mobileRuleList, disableAam);
            } else {
                mobileComponent = Attachment.create(Attachment.class, locale, column, columnRuleList,
                        bizData, digiwinAtmcBacklogDetail, mobileRuleList, disableAam);
            }
            Attachment attachment = (Attachment) mobileComponent;
            attachment.setSchema(bizDataSchema);
            if (TaskStringUtil.isPccTask(digiwinAtmcBacklogDetail.getTmTaskId(), digiwinAtmcBacklogDetail.getTmActivityId())) {
                // pcc 任务，附件上传数量限制 3个
                attachment.setLimit(3);
                if ("attachment1".equals(bizDataSchema)) {
                    // 手动任务交付物：100M
                    attachment.setFileMaxSize(new FileMaxSize(1024 * 1024 * 100L));
                } else if ("attachment2".equals(bizDataSchema)) {
                    // 附件：50M
                    attachment.setFileMaxSize(new FileMaxSize(1024 * 1024 * 50L));
                }
            }
            //当附件为只读状态且无默认数据时，不显示附件组件
            if (Objects.equals(attachment.getType(), AttachmentTypeEnum.READ_ONLY.getValue())
                    && (attachment.getFileList() == null || attachment.getFileList().size() == 0)) {

            } else {
                this.put(bizDataSchema, mobileComponent);
            }
        } else if (ColumnTagDefinitionCodeEnum.INPUT_SIGN.getCode().equalsIgnoreCase(column.getType()) ||
                (null != columnTag && columnTag.getTagDefinition().getCode()
                        .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.INPUT_SIGN.getCode()))
        ) {
            mobileComponent = InputSign.create(locale, column, columnRuleList, bizData, mobileRuleList);
            if (column.canEdit()) {
                ((BaseInputMobileComponent) mobileComponent).setEnable(true);
            } else {
                ((BaseInputMobileComponent) mobileComponent).setEnable(false);
            }
            this.put(bizDataSchema, mobileComponent);
        } else if (null != columnTag && columnTag.getTagDefinition().getCode()
                .equalsIgnoreCase(ColumnTagDefinitionCodeEnum.INPUT_DATETIME_PICKER.getCode())) {
            if (column.canEdit()) {
                mobileComponent = InputDateTimePicker.create(locale, column, columnRuleList, bizData, mobileRuleList);
                this.put(bizDataSchema, mobileComponent);
            } else {
                String value = column.getValueForDisplay(bizData);
                // 只读的话，空值，移动不显示
                if (!value.trim().isEmpty()) {
                    mobileComponent = Field.create(column, value);
                    this.put(column.getSchema(), mobileComponent);
                }
            }
        } else if ("FORM_LIST".equalsIgnoreCase(type) && InputOcr.COMPONENT_TYPE.equals(column.getMContentType())) {
            mobileComponent = InputOcr.create(locale, column, columnRuleList, bizData, mobileRuleList, digiwinAtmcBacklogDetail);
            this.put(column.getSchema(), mobileComponent);
        } else if ("boolean".equalsIgnoreCase(dataType) && "CHECKBOX".equalsIgnoreCase(type)) {
            if (column.canEdit()) {
                //InputSwitch
//                mobileComponent = InputSingleText.create(locale, column, columnRuleList, bizData, mobileRuleList);
                mobileComponent = InputSwitch.create(locale, column, columnRuleList, bizData, mobileRuleList);
                this.put(bizDataSchema, mobileComponent);
            } else {
                String value = column.getValueForDisplay(bizData);
                //Fixme 目前先暂时写死。后续可能要匹配表进行配置过滤
                value = "true".equalsIgnoreCase(value) ? "是" : "false".equalsIgnoreCase(value) ? "否" : value;
                // 只读的话，空值，移动不显示
                if (!value.trim().isEmpty()) {
                    mobileComponent = Field.create(column, value);
                    this.put(column.getSchema(), mobileComponent);
                }
            }
        } else {
            if (column.canEdit()) {
                mobileComponent = InputSingleText.create(locale, column, columnRuleList, bizData, mobileRuleList);
                this.put(bizDataSchema, mobileComponent);
            } else {
                String value = column.getValueForDisplay(bizData);
                // 只读的话，空值，移动不显示
                if (!value.trim().isEmpty()) {
                    Field field = Field.create(column, value);
                    field.setLabelStyleType(2);
                    mobileComponent = field;
                    this.put(column.getSchema(), mobileComponent);
                }
            }
        }


        // 记录实际的layout，最终会替换掉原来的${COMPONENT_TYPE}，返回给移动端
        if (null != mobileComponent) {
            UiBotLayout actualColumnLayout = new UiBotLayout();
            actualColumnLayout.setSchema(bizDataSchema);
            actualColumnLayout.setType(mobileComponent.returnComponentType());
            this.addActualLayout(actualColumnLayout);
        }
    }

    public void addEmptyComponent(ApiRequest apiRequest) {
        MobileComponent mobileComponent = Empty.create(
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "暂无数据"));
        String schema = Empty.COMPONENT_TYPE + "_" + UUID.randomUUID();
        this.put(schema, mobileComponent);

        // 记录实际的layout，最终会替换掉原来的${COMPONENT_TYPE}，返回给移动端
        UiBotLayout actualLayout = new UiBotLayout();
        actualLayout.setSchema(schema);
        actualLayout.setType(mobileComponent.returnComponentType());
        this.addActualLayout(actualLayout);
    }

    public void addCustomContentComponent(ApiRequest apiRequest) {
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        MobileComponent mobileComponent = Empty.create(
                localeService.getLanguageValue(apiRequest.getLocale(), "该任务已完成，请到web端查看"));
        String schema = Empty.COMPONENT_TYPE + "_" + UUID.randomUUID();
        this.put(schema, mobileComponent);

        // 记录实际的layout，最终会替换掉原来的${COMPONENT_TYPE}，返回给移动端
        UiBotLayout actualLayout = new UiBotLayout();
        actualLayout.setSchema(schema);
        actualLayout.setType(mobileComponent.returnComponentType());
        this.addActualLayout(actualLayout);
    }
}